% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secrets.R
\name{db_secrets_put}
\alias{db_secrets_put}
\title{Put Secret in Secret Scope}
\usage{
db_secrets_put(
  scope,
  key,
  value,
  as_bytes = FALSE,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{scope}{Name of the scope to which the secret will be associated with}

\item{key}{Unique name to identify the secret.}

\item{value}{Contents of the secret to store, must be a string.}

\item{as_bytes}{Boolean (default: \code{FALSE}). Determines if \code{value} is stored
as bytes.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Insert a secret under the provided scope with the given name.
}
\details{
If a secret already exists with the same name, this command overwrites the
existing secret’s value.

The server encrypts the secret using the secret scope’s encryption settings
before storing it. You must have \code{WRITE} or \code{MANAGE} permission on the secret
scope.

The secret key must consist of alphanumeric characters, dashes, underscores,
and periods, and cannot exceed 128 characters. The maximum allowed secret
value size is 128 KB. The maximum number of secrets in a given scope is 1000.

You can read a secret value only from within a command on a cluster
(for example, through a notebook); there is no API to read a secret value
outside of a cluster. The permission applied is based on who is invoking the
command and you must have at least \code{READ} permission.

The input fields \code{string_value} or \code{bytes_value} specify the type of the
secret, which will determine the value returned when the secret value is
requested. Exactly one must be specified, this function interfaces these
parameters via \code{as_bytes} which defaults to \code{FALSE}.
\itemize{
\item Throws \code{RESOURCE_DOES_NOT_EXIST} if no such secret scope exists.
\item Throws \code{RESOURCE_LIMIT_EXCEEDED} if maximum number of secrets in scope is
exceeded.
\item Throws \code{INVALID_PARAMETER_VALUE} if the key name or value length is
invalid.
\item Throws \code{PERMISSION_DENIED} if the user does not have permission to make
this API call.
}
}
\seealso{
Other Secrets API: 
\code{\link{db_secrets_delete}()},
\code{\link{db_secrets_list}()},
\code{\link{db_secrets_scope_acl_delete}()},
\code{\link{db_secrets_scope_acl_get}()},
\code{\link{db_secrets_scope_acl_list}()},
\code{\link{db_secrets_scope_acl_put}()},
\code{\link{db_secrets_scope_create}()},
\code{\link{db_secrets_scope_delete}()},
\code{\link{db_secrets_scope_list_all}()}
}
\concept{Secrets API}
