% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{brolgar-features}
\alias{brolgar-features}
\alias{feat_three_num}
\alias{feat_five_num}
\alias{feat_ranges}
\alias{feat_spread}
\alias{feat_monotonic}
\alias{feat_brolgar}
\alias{feat_diff_summary}
\title{Calculate features of a \code{tsibble} object in conjunction with \code{\link[=features]{features()}}}
\usage{
feat_three_num(x, ...)

feat_five_num(x, ...)

feat_ranges(x, ...)

feat_spread(x, ...)

feat_monotonic(x, ...)

feat_brolgar(x, ...)

feat_diff_summary(x, ...)
}
\arguments{
\item{x}{A vector to extract features from.}

\item{...}{Further arguments passed to other functions.}
}
\description{
You can calculate a series of summary statistics (features) of a given
variable for a dataset. For example, a three number summary, the minimum,
median, and maximum, can be calculated for a given variable. This is
designed to work with the \code{\link[=features]{features()}} function shown in the examples.
Other available features in \code{brolgar} include:
}
\details{
\itemize{
\item \code{\link[=feat_three_num]{feat_three_num()}} - minimum, median, maximum
\item \code{\link[=feat_five_num]{feat_five_num()}} - minimum, q25, median, q75, maximum.
\item \code{\link[=feat_ranges]{feat_ranges()}} - min, max, range difference, interquartile range.
\item \code{\link[=feat_spread]{feat_spread()}}  - variance, standard deviation, median absolute distance,
and interquartile range
\item \code{\link[=feat_monotonic]{feat_monotonic()}} - is it always increasing, decreasing, or unvarying?
\item \code{\link[=feat_diff_summary]{feat_diff_summary()}} - the summary statistics of the differences
amongst a value, including the five number summary, as well as the
standard deviation and variance. Returns NA if there is only one
observation, as we can't take the difference of one observation, and a
difference of 0 in these cases would be misleading.
\item \code{\link[=feat_brolgar]{feat_brolgar()}}  all features in brolgar.
}
}
\examples{

# You can use any of the features `feat_*` in conjunction with `features`
# like so:
heights \%>\%
  features(height_cm, # variable you want to explore
           feat_three_num) # the feature summarisation you want to perform
}
