% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schools.R
\docType{data}
\name{schools}
\alias{schools}
\alias{sch_sf}
\alias{tchr}
\alias{enrolment}
\alias{enrolment_MOE}
\title{Data sets relating to schools in Brunei}
\format{
An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 252 rows and 14 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 48 rows and 5 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 48 rows and 5 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 84 rows and 5 columns.
}
\usage{
sch_sf

tchr

enrolment

enrolment_MOE
}
\description{
Data sets relating to schools in Brunei
}
\details{
There are four datasets related to schools in Brunei:
\itemize{
\item \code{sch_sf}: A spatial object of schools in Brunei
\item \code{tchr}: A tibble of the number of teachers in schools in Brunei
\item \code{enrolment}: A tibble of the number of students in schools in Brunei
\item \code{enrolment_MOE}: A tibble of the number of students in schools in Brunei
}
}
\examples{
library(ggplot2)
ggplot() +
  geom_sf(data = brn_sf) +
  geom_sf(data = sch_sf)
}
\references{
\itemize{
\item \href{https://www.moe.gov.bn/DocumentDownloads/Forms/AllItems.aspx?RootFolder=\%2fDocumentDownloads\%2fEducation\%20Statistics\%20and\%20Indicators\%20Handbook&FolderCTID=0x012000686799B237388E4B93D164D060CACEC6}{Education Statistics and Indicators Handbook}.
Ministry of Education, Brunei.
\item \href{https://deps.mofe.gov.bn/SitePages/Statistical\%20Publications.aspx}{Summarised version, Y2023}
}
}
\keyword{datasets}
