% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboardHeader.R, R/aliases.R
\name{bs4UserMenu}
\alias{bs4UserMenu}
\alias{dashboardUserItem}
\alias{userOutput}
\alias{renderUser}
\alias{dashboardUser}
\title{Bootstrap 4 user profile.}
\usage{
bs4UserMenu(
  ...,
  name = NULL,
  image = NULL,
  title = NULL,
  subtitle = NULL,
  footer = NULL,
  status = NULL
)

dashboardUserItem(item, width)

userOutput(id, tag = shiny::tags$li)

renderUser(expr, env = parent.frame(), quoted = FALSE, outputArgs = list())

dashboardUser(
  ...,
  name = NULL,
  image = NULL,
  title = NULL,
  subtitle = NULL,
  footer = NULL,
  status = NULL
)
}
\arguments{
\item{...}{Body content. Slot for \link{dashboardUserItem}.}

\item{name}{User name.}

\item{image}{User profile picture.}

\item{title}{A title.}

\item{subtitle}{A subtitle.}

\item{footer}{Footer is any.}

\item{status}{Ribbon status. Valid colors are defined as follows:
\itemize{
\item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
\item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
\item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
\item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
\item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
\item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
\item \code{gray-dark}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#343a40")}.
\item \code{gray}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#adb5bd")}.
\item \code{white}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#fff")}.
\item \code{indigo}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6610f2")}.
\item \code{lightblue}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3c8dbc")}.
\item \code{navy}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#001f3f")}.
\item \code{purple}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#605ca8")}.
\item \code{fuchsia}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#f012be")}.
\item \code{pink}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#e83e8c")}.
\item \code{maroon}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#d81b60")}.
\item \code{orange}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ff851b")}.
\item \code{lime}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#01ff70")}.
\item \code{teal}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#39cccc")}.
\item \code{olive}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3d9970")}.
}}

\item{item}{HTML Tag.}

\item{width}{Item width between 1 and 12.}

\item{id}{Output variable name.}

\item{tag}{A tag function, like \code{tags$li} or \code{tags$ul}.}

\item{expr}{An expression that returns a Shiny tag object, \code{\link[shiny:HTML]{HTML()}},
or a list of such objects.}

\item{env}{The parent environment for the reactive expression. By default,
this is the calling environment, the same as when defining an ordinary
non-reactive expression. If \code{expr} is a quosure and \code{quoted} is \code{TRUE},
then \code{env} is ignored.}

\item{quoted}{If it is \code{TRUE}, then the \code{\link[=quote]{quote()}}ed value of \code{expr}
will be used when \code{expr} is evaluated. If \code{expr} is a quosure and you
would like to use its expression as a value for \code{expr}, then you must set
\code{quoted} to \code{TRUE}.}

\item{outputArgs}{A list of arguments to be passed through to the implicit
call to \code{\link[shiny:uiOutput]{uiOutput()}} when \code{renderUI} is used in an
interactive R Markdown document.}
}
\description{
\link{dashboardUser} to insert in the rightUi or leftUi slot of
\link{dashboardHeader}.

This can be inserted in a \code{\link{dashboardUser}}.

This can be used as a placeholder for dynamically-generated \code{\link{dashboardUser}}.
}
\examples{
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  shinyApp(
    ui = dashboardPage(
      header = dashboardHeader(rightUi = userOutput("user")),
      sidebar = dashboardSidebar(),
      body = dashboardBody(),
      title = "DashboardPage"
    ),
    server = function(input, output) {
      output$user <- renderUser({
        dashboardUser(
          name = "Divad Nojnarg",
          image = "https://adminlte.io/themes/AdminLTE/dist/img/user2-160x160.jpg",
          title = "shinydashboardPlus",
          subtitle = "Author",
          footer = p("The footer", class = "text-center"),
          fluidRow(
            dashboardUserItem(
              width = 6,
              "Item 1"
            ),
            dashboardUserItem(
              width = 6,
              "Item 2"
            )
          )
        )
      })
    }
  )
}
}
\seealso{
\code{\link{renderUser}} for the corresponding server side function
and examples.

\code{\link{userOutput}} for the corresponding client side function
and examples.
}
\concept{user outputs}
