% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.quantile.bspcov.R
\name{save_quantile_plot}
\alias{save_quantile_plot}
\title{Save quantile plot to file}
\usage{
save_quantile_plot(x, filename, width = NULL, height = 6, ...)
}
\arguments{
\item{x}{an object of class \code{quantile.bspcov}.}

\item{filename}{filename to save the plot.}

\item{width}{plot width. If NULL, calculated based on number of quantiles.}

\item{height}{plot height. Default is 6.}

\item{...}{additional arguments passed to \code{plot.quantile.bspcov} and \code{ggsave}.}
}
\description{
Convenience function to save quantile plots with appropriate dimensions.
}
\examples{
\donttest{
# Example with simulated data
n <- 25
p <- 50
Sigma0 <- diag(1, p)
X <- MASS::mvrnorm(n = n, mu = rep(0, p), Sigma = Sigma0)
res <- bspcov::bandPPP(X, 2, 0.01, nsample = 100)
quant <- quantile(res)
}
}
