% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append.R, R/carousel.R
\name{bs_append.bsplus_carousel}
\alias{bs_append.bsplus_carousel}
\alias{bs_carousel}
\title{Carousel}
\usage{
\method{bs_append}{bsplus_carousel}(tag, content, caption = NULL, ...)

bs_carousel(id, use_indicators = FALSE, use_controls = TRUE)
}
\arguments{
\item{tag}{\verb{htmltools::[tag][htmltools::tag]},
carousel \verb{<div/>} to which to append a panel}

\item{content}{character (HTML) or \verb{htmltools::[tagList][htmltools::tagList]},
content for the slide}

\item{caption}{character (HTML) or \verb{htmltools::[tagList][htmltools::tagList]},
caption for the slide}

\item{...}{other args (not used)}

\item{id}{character, unique id for accordion \verb{<div/>},
also serves as root id for slides appended using \code{bs_append()}}

\item{use_indicators}{logical, denotes use of slide-position indicators (dots)}

\item{use_controls}{logical, denotes use of controls (chevrons at sides)}
}
\value{
\code{bsplus_carousel} object (\verb{htmltools::[tag][htmltools::tag]},
\verb{<div/>})
}
\description{
A carousel is used to enclose a set of (typically) images,
providing controls to move slides back-and-forth.
}
\details{
All of these functions return a \code{bsplus_carousel} object
(which is also an \verb{htmltools::[tag][htmltools::tag]}, \verb{<div/>}), so you can
compose a carousel by piping. There are two parts to this system:

\enumerate{
\item{A constructor function for the carousel, \code{bs_carousel()}}
\item{A function to append a slide to the carousel, \code{bs_append()}}
}

The verb \emph{append} is used to signify that you can append an arbitrary
number of slides to a carousel.

For the constructor, \code{bs_carousel()},
it is your responsibility to ensure that \code{id} is unique
among HTML elements in your page. If you have non-unique \code{id}'s, strange things may
happen to your page.
}
\examples{
bs_carousel(id = "with_the_beatles") \%>\%
  bs_append(content = bs_carousel_image(src = "img/john.jpg")) \%>\%
  bs_append(content = bs_carousel_image(src = "img/paul.jpg")) \%>\%
  bs_append(content = bs_carousel_image(src = "img/george.jpg")) \%>\%
  bs_append(content = bs_carousel_image(src = "img/ringo.jpg"))

}
\seealso{
\url{https://getbootstrap.com/docs/3.3/javascript/#carousel},
\code{\link[=bs_carousel_image]{bs_carousel_image()}}, \code{\link[=bs_carousel_caption]{bs_carousel_caption()}}
}
