% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify.R
\name{verify_identification.PosteriorBSVAR}
\alias{verify_identification.PosteriorBSVAR}
\title{Verifies identification through heteroskedasticity or non-normality of 
of structural shocks}
\usage{
\method{verify_identification}{PosteriorBSVAR}(posterior)
}
\arguments{
\item{posterior}{the estimation outcome obtained using \code{\link{estimate}} function}
}
\value{
Nothing. Just displays a message.
}
\description{
Displays information that the model is homoskedastic and with normal shocks.
}
\examples{
# simple workflow
############################################################
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
specification  = specify_bsvar$new(us_fiscal_lsuw, p = 1)
set.seed(123)

# estimate the model
posterior      = estimate(specification, 10)

# verify heteroskedasticity
sddr           = verify_identification(posterior)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar$new(p = 1) |>
  estimate(S = 10) |> 
  verify_identification() -> sddr
  
}
\references{
Lütkepohl, H., and Woźniak, T., (2020) Bayesian Inference for Structural Vector Autoregressions Identified by Markov-Switching Heteroskedasticity. \emph{Journal of Economic Dynamics and Control} \bold{113}, 103862, \doi{10.1016/j.jedc.2020.103862}.

Lütkepohl, H., Shang, F., Uzeda, L., and Woźniak, T. (2024) Partial Identification of Heteroskedastic Structural VARs: Theory and Bayesian Inference. \emph{University of Melbourne Working Paper}, 1--57, \doi{10.48550/arXiv.2404.11057}.
}
\seealso{
\code{\link{verify_identification.PosteriorBSVAR}}, \code{\link{verify_identification.PosteriorBSVARSV}},
\code{\link{verify_identification.PosteriorBSVARMIX}}, \code{\link{verify_identification.PosteriorBSVARMSH}},
\code{\link{verify_identification.PosteriorBSVART}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
