% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{btw_tools}
\alias{btw_tools}
\title{Tools: Register tools from btw}
\usage{
btw_tools(...)
}
\arguments{
\item{...}{Optional names of tools or tool groups to include when registering
tools. By default all btw tools are included. For example, use \code{"docs"} to
include only the documentation related tools, or \verb{"env", "docs", "session"} for the collection of environment, documentation and session
tools, and so on.

The names provided can be:
\enumerate{
\item The name of a tool, such as \code{"btw_tool_env_describe_data_frame"}.
\item The name of a tool group, such as \code{"env"}, which will include all tools
in that group.
\item The tool name without the \code{btw_tool_} prefix, such as
\code{"env_describe_data_frame"}.
}}
}
\value{
Registers the tools with \code{chat}, updating the \code{chat} object in
place. The \code{chat} input is returned invisibly.
}
\description{
The \code{btw_tools()} function provides a list of tools that can be registered
with an ellmer chat via \code{chat$register_tools()} that allow the chat to
interface with your computational environment. Chats returned by
this function have access to the tools:
\subsection{Group: docs}{\tabular{ll}{
   Name \tab Description \cr
   \code{\link[=btw_tool_docs_available_vignettes]{btw_tool_docs_available_vignettes()}} \tab List available vignettes for an R package. \cr
   \code{\link[=btw_tool_docs_help_page]{btw_tool_docs_help_page()}} \tab Get help page from package. \cr
   \code{\link[=btw_tool_docs_package_help_topics]{btw_tool_docs_package_help_topics()}} \tab Get available help topics for an R package. \cr
   \code{\link[=btw_tool_docs_package_news]{btw_tool_docs_package_news()}} \tab Read the release notes (NEWS) for a package. \cr
   \code{\link[=btw_tool_docs_vignette]{btw_tool_docs_vignette()}} \tab Get a package vignette in plain text. \cr
}

}

\subsection{Group: env}{\tabular{ll}{
   Name \tab Description \cr
   \code{\link[=btw_tool_env_describe_data_frame]{btw_tool_env_describe_data_frame()}} \tab Show the data frame or table or get information about the structure of a data frame or table. \cr
   \code{\link[=btw_tool_env_describe_environment]{btw_tool_env_describe_environment()}} \tab List and describe items in the R session's global environment. \cr
}

}

\subsection{Group: files}{\tabular{ll}{
   Name \tab Description \cr
   \code{\link[=btw_tool_files_code_search]{btw_tool_files_code_search()}} \tab Search code files in the project. \cr
   \code{\link[=btw_tool_files_list_files]{btw_tool_files_list_files()}} \tab List files or directories in the project. \cr
   \code{\link[=btw_tool_files_read_text_file]{btw_tool_files_read_text_file()}} \tab Read an entire text file. \cr
   \code{\link[=btw_tool_files_write_text_file]{btw_tool_files_write_text_file()}} \tab Write content to a text file. \cr
}

}

\subsection{Group: git}{\tabular{ll}{
   Name \tab Description \cr
   \code{\link[=btw_tool_git_branch_checkout]{btw_tool_git_branch_checkout()}} \tab Switch to a different git branch. \cr
   \code{\link[=btw_tool_git_branch_create]{btw_tool_git_branch_create()}} \tab Create a new git branch. \cr
   \code{\link[=btw_tool_git_branch_list]{btw_tool_git_branch_list()}} \tab List git branches in the repository. \cr
   \code{\link[=btw_tool_git_commit]{btw_tool_git_commit()}} \tab Stage files and create a git commit. \cr
   \code{\link[=btw_tool_git_diff]{btw_tool_git_diff()}} \tab View changes in the working directory or a commit. \cr
   \code{\link[=btw_tool_git_log]{btw_tool_git_log()}} \tab Show the commit history for a repository. \cr
   \code{\link[=btw_tool_git_status]{btw_tool_git_status()}} \tab Show the status of the git working directory. \cr
}

}

\subsection{Group: github}{\tabular{ll}{
   Name \tab Description \cr
   \code{\link[=btw_tool_github]{btw_tool_github()}} \tab Execute R code that calls the GitHub API using gh(). \cr
}

}

\subsection{Group: ide}{\tabular{ll}{
   Name \tab Description \cr
   \code{\link[=btw_tool_ide_read_current_editor]{btw_tool_ide_read_current_editor()}} \tab Read the contents of the editor that is currently open in the user's IDE. \cr
}

}

\subsection{Group: pkg}{\tabular{ll}{
   Name \tab Description \cr
   \code{\link[=btw_tool_pkg_check]{btw_tool_pkg_check()}} \tab Run comprehensive package checks. \cr
   \code{\link[=btw_tool_pkg_coverage]{btw_tool_pkg_coverage()}} \tab Compute test coverage for an R package. \cr
   \code{\link[=btw_tool_pkg_document]{btw_tool_pkg_document()}} \tab Generate package documentation. \cr
   \code{\link[=btw_tool_pkg_test]{btw_tool_pkg_test()}} \tab Run testthat tests for an R package. \cr
}

}

\subsection{Group: run}{\tabular{ll}{
   Name \tab Description \cr
   \code{\link[=btw_tool_run_r]{btw_tool_run_r()}} \tab Run R code. \cr
}

}

\subsection{Group: search}{\tabular{ll}{
   Name \tab Description \cr
   \code{\link[=btw_tool_search_package_info]{btw_tool_search_package_info()}} \tab Describe a CRAN package. \cr
   \code{\link[=btw_tool_search_packages]{btw_tool_search_packages()}} \tab Search for an R package on CRAN. \cr
}

}

\subsection{Group: session}{\tabular{ll}{
   Name \tab Description \cr
   \code{\link[=btw_tool_session_check_package_installed]{btw_tool_session_check_package_installed()}} \tab Check if a package is installed in the current session. \cr
   \code{\link[=btw_tool_session_package_info]{btw_tool_session_package_info()}} \tab Verify that a specific package is installed, or find out which packages are in use in the current session. \cr
   \code{\link[=btw_tool_session_platform_info]{btw_tool_session_platform_info()}} \tab Describes the R version, operating system, language and locale settings for the user's system. \cr
}

}

\subsection{Group: web}{\tabular{ll}{
   Name \tab Description \cr
   \code{\link[=btw_tool_web_read_url]{btw_tool_web_read_url()}} \tab Read a web page and convert it to Markdown format. \cr
}

}
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) withAutoprint(\{ # examplesIf}
# requires an ANTHROPIC_API_KEY
ch <- ellmer::chat_anthropic()

# register all of the available tools
ch$register_tools(btw_tools())

# or register only the tools related to fetching documentation
ch$register_tools(btw_tools("docs"))

# ensure that the current tools persist
ch$register_tools(c(ch$get_tools(), btw_tools()))
\dontshow{\}) # examplesIf}
}
