% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-env.R
\name{btw_tool_env_describe_environment}
\alias{btw_tool_env_describe_environment}
\title{Tool: Describe an environment}
\usage{
btw_tool_env_describe_environment(items = NULL, `_intent` = "")
}
\arguments{
\item{items}{Optional. A character vector of objects in the environment to
describe.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
A string describing the environment contents with \verb{#>} prefixing
each object's printed representation.
}
\description{
This tool can be used by the LLM to describe the contents of an R session,
i.e. the data frames and other objects loaded into the global environment.
This tool will only see variables that you've named and created in the
global environment, it cannot reach into package namespaces, see which
packages you have loaded, or access files on your computer.
}
\examples{
my_cars <- mtcars[mtcars$mpg > 25, ]
btw_tool_env_describe_environment("my_cars")

}
\seealso{
\code{\link[=btw_this.environment]{btw_this.environment()}}, \code{\link[=btw_tools]{btw_tools()}}

Other env tools: 
\code{\link{btw_tool_env_describe_data_frame}()}
}
\concept{env tools}
