% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/end_to_end_cp_algorithm_v2.R
\name{get_grooves_bcp}
\alias{get_grooves_bcp}
\title{Conforming get_grooves_"name" function.}
\usage{
get_grooves_bcp(x, value, adjust = 10, ...)
}
\arguments{
\item{x}{numeric vector of locations in microns}

\item{value}{numeric vector of surface measurements in microns}

\item{adjust}{positive number to adjust the grooves - XXX should be
expressed in microns rather than an index}

\item{...}{Additional arguments to be passed to detect_cp_v2.}
}
\value{
A named list containing the output from variable_cp_gibbs function, the range of
data that was actually used for the changepoint algorithm (since it doesn't impute values
past the outermost non-missing values), and the estimated groove locations.
}
\description{
This is a wrapper function that comforms to the other get_grooves functions.
}
\examples{
data("example_data")
head(raw_data)
raw_data <- raw_data[seq(from = 1, to = nrow(raw_data), by = 30),]
cp_gibbs3 <- get_grooves_bcp(x = raw_data$x,
    value = raw_data$value,
    adjust = 10,
    iter = 300,
    warmup = 100)
}
