% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/18_aLongStock.R
\name{aLongStock}
\alias{aLongStock}
\title{Calculates Profit and Loss (PnL) per share (or unit of the underlying) and Breakeven point of a long position in a stock, at the time of sale of the held stock, and draws its graph in the Plots tab.}
\usage{
aLongStock(
  ST,
  S0,
  C = 0,
  hl = 0,
  hu = 1.8,
  xlab = "Spot Price ($) on Expiration",
  ylab = "Realized Profit / Loss [ PnL ] upon Sale ($)",
  main = "Long Stock ",
  sub = "bullishTrader / MaheshP Kumar"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{S0}{Initial Stock Price}

\item{C}{Transaction Cost.}

\item{hl}{lower bound value for setting lower limit of X axis displaying spot price.}

\item{hu}{upper bound value for setting upper limit of X axis displaying spot price.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{main}{Title of the Graph.}

\item{sub}{Subtitle of the Graph.}
}
\value{
returns a profit and loss graph of Covered Call.
}
\description{
Long stock is owning and holding the stock on the expectation that its price will rise (Hull, 2022).
}
\details{
This method is developed, and the given examples are created, to compute per share Profit and Loss at the time of the sale of a held stock and also the Breakeven (BE) point for a long stock position and draws its graph in the Plots tab.
}
\examples{
aLongStock(20,18)
aLongStock(90,85,hl=0.7,hu=1.2)
aLongStock(1000,990,hl=0.97,hu=1.02)
aLongStock(1000,990,5,hl=0.97,hu=1.02)
}
\references{
Hull, J. C. (2022). Options, Futures, and Other Derivatives (11th ed.). Pearson Education (US). https://bookshelf.vitalsource.com/books/9780136940043.
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
