% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confIntv.R
\name{conf.intv}
\alias{conf.intv}
\title{Observed Fisher information based confidence interval of Block-Basu Bivariate
Pareto (BBBVPA) distribution}
\usage{
conf.intv(
  object,
  conf.lev = 0.95,
  tol = 1e-04,
  intv.m1 = c(0, 2),
  intv.m2 = c(0, 2)
)
}
\arguments{
\item{object}{\code{"bbbvpa"} class object.}

\item{conf.lev}{confidence level, \eqn{0.95} (default).}

\item{tol}{convergence tolerance for confidence intervals, \code{0.0001} (default).}

\item{intv.m1}{interval related to confidence interval of \eqn{\mu_1}, \code{c(0,2)} (default).}

\item{intv.m2}{interval related to confidence interval of \eqn{\mu_1}, \code{c(0,2)} (default).}
}
\value{
A matrix of lower and upper confidence interval limits (in the first and second column respectively).
The matrix rows are labeled by the parameter names (if any) and columns by the corresponding
distribution quantiles.
}
\description{
Observed Fisher information based confidence interval of Bivariate BBBVPA
distribution.
}
\examples{
# see the example of estimation

}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Arabin Kumar Dey <arabin@iitg.ac.in>
}
