% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogLik.R
\name{logL}
\alias{logL}
\title{Log-likelihood function of Block-Basu Bivariate Pareto (BBBVPA) distribution}
\usage{
logL(I, mu1, mu2, s1, s2, a0, a1, a2)
}
\arguments{
\item{I}{baivariate observations.}

\item{mu1}{value of \eqn{\mu_1}.}

\item{mu2}{value of \eqn{\mu_2}.}

\item{s1}{value of \eqn{\sigma_1}.}

\item{s2}{value of \eqn{\sigma_2}.}

\item{a0}{value of \eqn{\alpha_0}.}

\item{a1}{value of \eqn{\alpha_1}.}

\item{a2}{value of \eqn{\alpha_2}.}
}
\value{
a list consisting of
\item{logLik}{A scalar numeric, log likelihood of the model.}
\item{n1, n2}{\eqn{n_1} and \eqn{n_2}.}
}
\description{
Return the log likelihood value.
}
\examples{
dat <- rbb.bvpa(500, 0.1, 0.1, 0.8, 0.8, 2.0, 0.4, 0.5)
logL(dat, 0.1, 0.1, 0.8, 0.8, 2.0, 0.4, 0.5)

}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Arabin Kumar Dey <arabin@iitg.ac.in>
}
