% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.CI.R
\name{param.boot}
\alias{param.boot}
\title{Parametric bootstrap confidence intervals of parameters of Block-Basu Bivariate
Pareto (BBBVPA) distribution}
\usage{
param.boot(
  data,
  s1.int,
  s2.int,
  a0.int,
  a1.int,
  a2.int,
  conf.lev = 0.95,
  intv.m1 = c(0, 2),
  intv.m2 = c(0, 2),
  no.paboot = 100,
  tol = 1e-04,
  ...
)
}
\arguments{
\item{data}{bivariate observations.}

\item{s1.int}{initial choice of \eqn{\sigma_1}.}

\item{s2.int}{initial choice of \eqn{\sigma_2}.}

\item{a0.int}{initial choice of \eqn{\alpha_0}.}

\item{a1.int}{initial choice of \eqn{\alpha_1}.}

\item{a2.int}{initial choice of \eqn{\alpha_2}.}

\item{conf.lev}{confidence level, defult \eqn{0.95}.}

\item{intv.m1}{interval related to confidence interval of \eqn{\mu_1}, \code{c(0,2)} (default).}

\item{intv.m2}{interval related to confidence interval of \eqn{\mu_1}, \code{c(0,2)} (default).}

\item{no.paboot}{number of bootstrap samples, \code{100} (default).}

\item{tol}{convergence tolerance for confidence interval of \eqn{\mu_1}.
and \eqn{\mu_2}, \code{0.0001} (default).}

\item{...}{further arguments to pass to \code{estimates}.}
}
\value{
A matrix of lower and upper confidence interval limits (in the first and second column respectively).
The matrix rows are labeled by the parameter names (if any) and columns by the corresponding
distribution quantiles.
}
\description{
Parametric bootstrap confidence interval of parameters of BBBVPA distribution.
}
\examples{
# see the example of estimation

}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Arabin Kumar Dey <arabin@iitg.ac.in>
}
