% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zotero_gov.R
\name{ZoteroGov}
\alias{ZoteroGov}
\title{Wrangle regjeringen.no metadata into Zotero-type format}
\usage{
ZoteroGov(search, type = "NOU", meta = list(), silent = TRUE, log = list())
}
\arguments{
\item{search}{Search term (e.g., 2018: 2)}

\item{type}{type of query (e.g., white paper, official norwegian reports),
Default: "NOU"}

\item{meta}{A list collecting all metadata used to create , Default: list()}

\item{silent}{c2z is noisy, tell it to be quiet, Default: TRUE}

\item{log}{A list for storing log elements, Default: list()}
}
\value{
A Zotero-type matrix (tibble)
}
\description{
Query regjeringen by search word and type and fetch metadata
}
\details{
Please see
  \href{https://oeysan.github.io/c2z/}{https://oeysan.github.io/c2z/}
}
\examples{
\donttest{
  # Search the default entity, Norwegian official reports in regjeringen.no
  example <- ZoteroGov("2001:4")
  # Print index using `ZoteroIndex`
  if (any(nrow(example$data))) {
  ZoteroIndex(example$data) |>
    dplyr::select(name) |>
    print(width = 80)
  }
}
}
\seealso{
\code{\link[httr]{RETRY}}
 \code{\link[rvest]{reexports}}
 \code{\link[dplyr]{bind}}, \code{\link[dplyr]{arrange}}
}
