% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrar-main.R
\name{optimh}
\alias{optimh}
\title{General-purpose optimization using heuristic algorithms}
\usage{
optimh(
  par,
  fn,
  gr = NULL,
  ...,
  method = c("AHR-ES", "Nelder-Mead", "SANN", "hjn", "bobyqa", "CMA-ES", "genSA", "DE",
    "soma", "genoud", "PSO", "hybridPSO", "mads", "hjk", "hjkb", "nmk", "nmkb"),
  lower = -Inf,
  upper = +Inf,
  active = NULL,
  control = list(),
  hessian = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{par}{A numeric vector or list. The length of the par argument defines the 
number of parameters to be estimated (i.e. the dimension of the problem).}

\item{fn}{The function to be minimized.}

\item{gr}{Function to compute the gradient of \code{fn}. Ignored by most methods, 
added for consistency with other optimization functions.}

\item{...}{Additional parameters to be passed to \code{fn}.}

\item{method}{The optimization method to be used. The default method
is the AHR-ES (Adaptative Hierarchical Recombination Evolutionary Strategy, 
Oliveros-Ramos & Shin, 2016). See details for the methods available.}

\item{lower}{Lower threshold value(s) for parameters. One value or a vector 
of the same length as par. If one value is provided, it is used for all 
parameters. \code{NA} means \code{-Inf}. By default \code{-Inf} is used (unconstrained).}

\item{upper}{Upper threshold value(s) for parameters. One value or a vector 
of the same length as par. If one value is provided, it is used for all 
parameters. \code{NA} means \code{Inf}. By default \code{Inf} is used (unconstrained).}

\item{active}{Boolean vector of the same length as par, indicating if the 
parameter is used in the optimization (TRUE) or hold at a fixed value (FALSE).}

\item{control}{Parameter for the control of the algorithm itself, see details.}

\item{hessian}{Logical. Should a numerically differentiated Hessian matrix be returned?
Currently not implemented.}

\item{parallel}{Logical. Use parallel computation numerical of gradient?}
}
\value{
A list with components:
\describe{
\item{par}{The best set of parameters found.}
\item{value}{The value of fn corresponding to par.}
\item{counts}{A two-element integer vector giving the number of calls to fn and gr respectively. This excludes those calls needed to compute the Hessian, if requested, and any calls to fn to compute a finite-difference approximation to the gradient.}
\item{convergence}{An integer code. 0 indicates successful completion. }
\item{message}{A character string giving any additional information returned by the optimizer, or NULL.}
\item{hessian}{Only if argument hessian is true. A symmetric matrix giving an estimate of the Hessian at the solution found. Note that this is the Hessian of the unconstrained problem even if the box constraints are active.}
}
}
\description{
General-purpose optimization using heuristic algorithms
}
\examples{
optim2(par=rep(NA, 5), fn=sphereN)
}
\seealso{
Other optimisers: 
\code{\link{ahres}()},
\code{\link{calibrate}()},
\code{\link{optim2}()}
}
\author{
Ricardo Oliveros-Ramos
}
\concept{optimisers}
