% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.KLR.R
\name{cv.KLR}
\alias{cv.KLR}
\title{K-fold cross-validation for Kernel Logistic Regression}
\usage{
cv.KLR(X, y, K = 5, lambda = seq(0.001, 0.2, 0.005), kernel = c("matern",
  "exponential")[1], nu = 1.5, power = 1.95, rho = seq(0.05, 0.5, 0.05))
}
\arguments{
\item{X}{input for \code{KLR}.}

\item{y}{input for \code{KLR}.}

\item{K}{a positive integer specifying the number of folds. The default is 5.}

\item{lambda}{a vector specifying lambda values at which CV curve will be computed.}

\item{kernel}{input for \code{KLR}.}

\item{nu}{input for \code{KLR}.}

\item{power}{input for \code{KLR}.}

\item{rho}{rho value at which CV curve will be computed.}
}
\value{
\item{lambda}{value of \code{lambda} that gives minimum CV error.}
\item{rho}{value of \code{rho} that gives minimum CV error.}
}
\description{
The function performs k-fold cross validation for kernel logistic regression to estimate tuning parameters.
}
\details{
This function performs the k-fold cross-valibration for a kernel logistic regression. The CV curve is computed at the values of the tuning parameters assigned by \code{lambda} and \code{rho}. The number of fold is given by \code{K}.
}
\examples{
library(calibrateBinary)

set.seed(1)
np <- 10
xp <- seq(0,1,length.out = np)
eta_fun <- function(x) exp(exp(-0.5*x)*cos(3.5*pi*x)-1) # true probability function
eta_x <- eta_fun(xp)
yp <- rep(0,np)
for(i in 1:np) yp[i] <- rbinom(1,1, eta_x[i])

x.test <- seq(0,1,0.001)
etahat <- KLR(xp,yp,x.test)

plot(xp,yp)
curve(eta_fun, col = "blue", lty = 2, add = TRUE)
lines(x.test, etahat, col = 2)

#####   cross-validation with K=5    #####
##### to determine the parameter rho #####

cv.out <- cv.KLR(xp,yp,K=5)
print(cv.out)

etahat.cv <- KLR(xp,yp,x.test,lambda=cv.out$lambda,rho=cv.out$rho)

plot(xp,yp)
curve(eta_fun, col = "blue", lty = 2, add = TRUE)
lines(x.test, etahat, col = 2)
lines(x.test, etahat.cv, col = 3)

}
\author{
Chih-Li Sung <iamdfchile@gmail.com>
}
\seealso{
\code{\link{KLR}} for performing a kernel logistic regression with given \code{lambda} and \code{rho}.
}

