% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sme_emissions_profile.R
\name{sme_emissions_profile}
\alias{sme_emissions_profile}
\title{SME Emissions Profile}
\usage{
sme_emissions_profile(sic_code, turnover, company_name = NULL)
}
\arguments{
\item{sic_code}{A 2-digit UK SIC code (numeric).}

\item{turnover}{Annual turnover value (numeric).}

\item{company_name}{Optional company name for labeling plots (character string).}
}
\value{
A list with four elements: \code{scope1}, \code{scope2} \code{scope3}, \code{scope3_hotspots}, each containing the predicted carbon emissions data frame (in tCo2e), the top 5 scope 3 emissions hotspots, as well as a donut chart and Sankey diagram showing the emissions breakdowns.
}
\description{
Calls the Scope 1, 2 and 3 emissions prediction functions and returns their results as a list and plots a donut chart
}
\examples{
sme_emissions_profile(sic_code = 85, turnover = 12000000, company_name = "Carbon Predict LTD")
}
