% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carbon_price_credit.R
\name{carbon_price_credit}
\alias{carbon_price_credit}
\title{Calculate carbon price credit}
\usage{
carbon_price_credit(
  jurisdiction = NULL,
  year = NULL,
  period = 0,
  manual_price = NULL,
  co2e_val
)
}
\arguments{
\item{jurisdiction}{A character string specifying the jurisdiction for which the carbon price credit should be calculated.}

\item{year}{An optional numeric value specifying the year for which the carbon price credit should be calculated.
If \code{NULL}, the most recent year available in the CPI data will be used.}

\item{period}{An optional numeric value specifying the period within the specified year for which the carbon price credit should be calculated.
If \code{1}, the function will use the first period if it is available; if \code{2}, the function will use the second period if it is available. If \code{0}, the function will calculate the mean between the first and second period.}

\item{manual_price}{An option to manually input a carbon price index to override the value in the World Bank Data.
This should be a value of the carbon credit price per tCO2e.}

\item{co2e_val}{A numeric value specifying the CO2e (carbon dioxide equivalent) value for which the carbon price credit should be calculated.}
}
\value{
The calculated carbon price credit in USD ($).
}
\description{
This function calculates the carbon price credit for a given jurisdiction, year, period, and CO2e value.
It uses CPI (Carbon Price Index) data to determine the carbon price for the specified jurisdiction and time period.
The carbon price credit is calculated by multiplying the CO2e value by the corresponding carbon price.
}
\examples{
# Calculate carbon price credit for the United Kingdom in the year 2000,
# period 2, and CO2e value of 100
carbon_price_credit("United Kingdom", 2022, 2, co2e_val = 100)

# Or manually enter a value
carbon_price_credit(manual_price = 66.9, co2e_val = 100)
}
