% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinical_theatre_data.R
\name{clinical_theatre_data}
\alias{clinical_theatre_data}
\title{Clinical Emissions: Data Frame and Plot}
\usage{
clinical_theatre_data(
  data,
  time,
  date_format = "\%d/\%m/\%Y",
  name,
  wet_clinical_waste,
  wet_clinical_waste_unit = c("tonnes", "kg"),
  desflurane = 0,
  sevoflurane = 0,
  isoflurane = 0,
  methoxyflurane = 0,
  N2O = 0,
  propofol = 0,
  water_supply = NULL,
  water_trt = TRUE,
  water_unit = c("cubic metres", "million litres"),
  electricity_kWh = NULL,
  electricity_TD = TRUE,
  electricity_WTT = TRUE,
  heat_kWh = NULL,
  heat_TD = TRUE,
  heat_WTT = TRUE,
  paper_vars = NULL,
  plastic_vars = NULL,
  metal_vars = NULL,
  electrical_vars = NULL,
  construction_vars = NULL,
  paper_waste = TRUE,
  plastic_waste = TRUE,
  metal_waste = TRUE,
  electrical_waste = TRUE,
  construction_waste = TRUE,
  paper_material_production = "Primary material production",
  metal_material_production = "Primary material production",
  construction_material_production = "Primary material production",
  paper_waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill"),
  plastic_waste_disposal = c("Landfill", "Open-loop", "Closed-loop", "Combustion"),
  metal_waste_disposal = c("Closed-loop", "Combustion", "Landfill", "Open-loop"),
  electrical_waste_disposal = c("Landfill", "Open-loop"),
  construction_waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill",
    "Open-loop"),
  units = "kg",
  value_col = c("value", "value_2024"),
  strict = TRUE,
  include_cpi = FALSE,
  jurisdiction = NULL,
  year = NULL,
  period = 0,
  manual_price = NULL,
  gti_by = c("default", "month", "year"),
  overall_by = c("default", "month", "year"),
  single_sheet = FALSE
)
}
\arguments{
\item{data}{Data frame containing all variables required for emissions calculation.}

\item{time}{Column in \code{data} giving the time variable.}

\item{date_format}{Character string of date format for \code{time} (default: \code{"\%d/\%m/\%Y"}).}

\item{name}{Column in \code{data} giving the theatre identifier/name.}

\item{wet_clinical_waste}{Numeric. Amount of (wet) clinical waste.}

\item{wet_clinical_waste_unit}{Unit for \code{wet_clinical_waste} (\code{"tonnes"} or \code{"kg"}).}

\item{desflurane}{Amount of desflurane used in KG (default: 0).}

\item{sevoflurane}{Amount of sevoflurane used in KG (default: 0).}

\item{isoflurane}{Amount of isoflurane used in KG (default: 0).}

\item{methoxyflurane}{Amount of methoxyflurane used in KG (default: 0).}

\item{N2O}{Amount of nitrous oxide (N2O) used in KG (default: 0).}

\item{propofol}{Amount of propofol used in KG (default: 0).}

\item{water_supply}{numeric, amount of water in the given unit.}

\item{water_trt}{logical, include treatment emissions (default TRUE).}

\item{water_unit}{"cubic metres" or "million litres".}

\item{electricity_kWh}{numeric kWh consumed.}

\item{electricity_TD}{logical, include T&D losses (default TRUE).}

\item{electricity_WTT}{logical, include WTT for electricity (default TRUE).}

\item{heat_kWh}{numeric kWh of heat/steam (onsite; excludes district).}

\item{heat_TD}{logical, include district heat distribution losses (default TRUE).}

\item{heat_WTT}{logical, include WTT for heat/steam (default TRUE).}

\item{paper_vars}{Named character vector mapping canonical paper keys
(\code{"board"}, \code{"mixed"}, \code{"paper"}) to column names in \code{data}.
Each row’s values are passed as a \code{paper_use} vector.}

\item{plastic_vars}{Named character vector mapping canonical plastic keys
(e.g. \code{"average"}, \code{"pet"}, \code{"pp"}, \code{"pvc"}, …) to columns in \code{data}.}

\item{metal_vars}{Named character vector mapping canonical metal keys
(e.g. \code{"aluminuim_cans"}, \code{"steel_cans"}, \code{"scrap"}) to columns in \code{data}.}

\item{electrical_vars}{Named character vector mapping canonical electrical keys
(e.g. \code{"fridges"}, \code{"freezers"}, \code{"it"}, \code{"alkaline_batteries"}) to columns in \code{data}.}

\item{construction_vars}{Named character vector mapping canonical construction keys
(e.g. \code{"concrete"}, \code{"bricks"}, \code{"wood"}, \code{"metals"}) to columns in \code{data}.}

\item{paper_waste, plastic_waste, metal_waste, electrical_waste, construction_waste}{Logical. Whether the same tonnage is assumed to go to waste treatment for
that material type (default: \code{TRUE}).}

\item{paper_material_production, metal_material_production, construction_material_production}{Column text string for material-use factor (default: \code{"Primary material production"}).}

\item{paper_waste_disposal, plastic_waste_disposal, metal_waste_disposal, electrical_waste_disposal, construction_waste_disposal}{Disposal route(s) to use for each material category. See \code{\link[=material_emissions]{material_emissions()}}
for valid options.}

\item{units}{Units of result, \code{"kg"} or \code{"tonnes"}. Default: \code{"kg"}.}

\item{value_col}{Which column of \code{uk_gov_data} to use (\code{"value"} or \code{"value_2024"}).}

\item{strict}{Logical. If \code{TRUE}, error when a factor is missing; if \code{FALSE}, treat as zero.}

\item{include_cpi}{Logical. Whether to add carbon price credit calculations.}

\item{jurisdiction}{Jurisdiction string for CPI lookup (see \code{\link[=check_CPI]{check_CPI()}}).}

\item{year, period}{CPI year and period to use.}

\item{manual_price}{Optional numeric CPI value to override World Bank data.}

\item{gti_by}{Grouping type for GTI calculation (\code{"default"}, \code{"month"}, \code{"year"}).}

\item{overall_by}{Grouping type for overall output plot.}

\item{single_sheet}{\code{NULL}, \code{TRUE}, or \code{FALSE}. If not \code{NULL}, returns a list
with the emissions table and a single-sheet display/plot.}
}
\value{
If \code{single_sheet = NULL}: a tibble with emissions (and \code{carbon_price_credit}
if \code{include_cpi = TRUE}).

If \code{single_sheet = TRUE}/\code{FALSE}: a list with the emissions table and
a plot object generated by \code{\link[=output_display]{output_display()}}.
}
\description{
Calculate clinical theatre emissions row-by-row from a data frame.
Each row is expanded into a call to \code{\link[=clinical_theatre_emissions]{clinical_theatre_emissions()}} using
the columns you specify. Optionally, results can be combined with
carbon price credit information and plotted.
}
\examples{
df <- data.frame(
  time = c("10/04/2000","11/04/2000"),
  theatre = c("A","A"),
  clinical_waste = c(80,90),
  electricity_kwh = c(100,110),
  general_waste = c(65,55)
)

clinical_theatre_data(
  df,
  time = time,
  name = theatre,
  wet_clinical_waste = clinical_waste,
  wet_clinical_waste_unit = "kg",
  electricity_kWh = electricity_kwh,
  plastic_vars = c(average="general_waste"),
  units = "kg"
)
}
