% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_instance.R
\name{generate_instance_roc}
\alias{generate_instance_roc}
\title{Generate data sets under realistic parameter configurations}
\usage{
generate_instance_roc(
  nrep = 10,
  n = 100,
  prev = 0.5,
  random = FALSE,
  m = 10,
  auc = "seq(0.85, 0.95, length.out = 5)",
  rhose = 0.5,
  rhosp = 0.5,
  dist = "normal",
  e = 10,
  k = 100,
  delta = 0,
  ...,
  data = NULL,
  job = NULL
)
}
\arguments{
\item{nrep}{(numeric) \cr integer, number of instances}

\item{n}{(numeric) \cr integer, total sample size}

\item{prev}{(numeric) \cr disease prevalence}

\item{random}{(logical) \cr fixed prevalence (FALSE) or simple random sampling (TRUE)}

\item{m}{(numeric) \cr integer, number of candidates}

\item{auc}{(numeric) \cr vector of AUCs of biomarkers}

\item{rhose}{(numeric) \cr correlation parameter for sensitivity}

\item{rhosp}{(numeric) \cr correlation parameter for specificity}

\item{dist}{(character) \cr either "normal" or "exponential" specifying the subgroup biomarker distributions}

\item{e}{(numeric) \cr emulates better (worse) model selection quality with higher (lower) values of e}

\item{k}{(numeric) \cr technical parameter which adjusts grid size}

\item{delta}{(numeric) \cr specify importance between sensitivity and specificity (default 0: equal importance)}

\item{...}{(any) \cr further arguments}

\item{data}{(NULL) \cr ignored (for batchtools compatibility)}

\item{job}{(NULL) \cr ignored (for batchtools compatibility)}
}
\value{
(list) \cr a single (ROC) simulation instance of length \code{nrep}
}
\description{
Generates a (simulation) instance, a list of multiple datasets to be processed
(analyzed) with \link{process_instance}. Ground truth parameters (Sensitvity & Specificity) are
initially generated according to a generative model whereby multiple decision rules (with
different parameter values) are derived by thresholding multiple biomarkers.

\strong{This function is only needed for simulation via batchtools, not relevant in interactive use!}
}
\details{
Utilizes same arguments as \link{draw_data_roc} unless mentioned otherwise above.
}
