% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_lmm_initialization.R
\name{cat_lmm_initialization}
\alias{cat_lmm_initialization}
\title{Initialization for Catalytic Linear Mixed Model (LMM)}
\usage{
cat_lmm_initialization(
  formula,
  data,
  x_cols,
  y_col,
  z_cols,
  group_col = NULL,
  syn_size = NULL,
  resample_by_group = FALSE,
  resample_only = FALSE,
  na_replace = mean
)
}
\arguments{
\item{formula}{A formula specifying the model. Should include response and predictor variables.}

\item{data}{A data frame containing the data for modeling.}

\item{x_cols}{A character vector of column names for fixed effects (predictors).}

\item{y_col}{A character string for the name of the response variable.}

\item{z_cols}{A character vector of column names for random effects.}

\item{group_col}{A character string for the grouping variable (optional). If not given (NULL), it is extracted from the formula.}

\item{syn_size}{An integer specifying the size of the synthetic dataset to be generated, default is length(x_cols) * 4.}

\item{resample_by_group}{A logical indicating whether to resample by group, default is FALSE.}

\item{resample_only}{A logical indicating whether to perform resampling only, default is FALSE.}

\item{na_replace}{A function to replace NA values in the data, default is mean.}
}
\value{
A list containing the values of all the input arguments and the following components:
\itemize{
\item \strong{Function Information}:
\itemize{
\item \code{function_name}: A character string representing the name of the function, "cat_lmm_initialization".
\item \code{simple_model}: An object of class \code{lme4::lmer} or \code{stats::lm}, representing the fitted model for generating synthetic response from the original data.
}
\item \strong{Observation Data Information}:
\itemize{
\item \code{obs_size}: An integer representing the number of observations in the original dataset.
\item \code{obs_data}: The original data used for fitting the model, returned as a data frame.
\item \code{obs_x}: A data frame containing the standardized predictor variables from the original dataset.
\item \code{obs_y}: A numeric vector of the standardized response variable from the original dataset.
\item \code{obs_z}: A data frame containing the standardized random effect variables from the original dataset.
\item \code{obs_group}: A numeric vector representing the grouping variable for the original observations.
}
\item \strong{Synthetic Data Information}:
\itemize{
\item \code{syn_size}: An integer representing the number of synthetic observations generated.
\item \code{syn_data}: A data frame containing the synthetic dataset, combining synthetic predictor and response variables.
\item \code{syn_x}: A data frame containing the synthetic predictor variables.
\item \code{syn_y}: A numeric vector of the synthetic response variable values.
\item \code{syn_z}: A data frame containing the synthetic random effect variables.
\item \code{syn_group}: A numeric vector representing the grouping variable for the synthetic observations.
\item \code{syn_x_resample_inform}: A data frame containing information about the resampling process for synthetic predictors:
\itemize{
\item Coordinate: Preserves the original data values as reference coordinates during processing.
\item Deskewing: Adjusts the data distribution to reduce skewness and enhance symmetry.
\item Smoothing: Reduces noise in the data to stabilize the dataset and prevent overfitting.
\item Flattening: Creates a more uniform distribution by modifying low-frequency categories in categorical variables.
\item Symmetrizing: Balances the data around its mean to improve statistical properties for model fitting.
}
\item \code{syn_z_resample_inform}: A data frame containing information about the resampling process for synthetic random effects. The resampling methods are the same as those from \code{syn_x_resample_inform}.
}
\item \strong{Whole Data Information}:
\itemize{
\item \code{size}: An integer representing the total size of the combined original and synthetic datasets.
\item \code{data}: A combined data frame of the original and synthetic datasets.
\item \code{x}: A combined data frame of the original and synthetic predictor variables.
\item \code{y}: A combined numeric vector of the original and synthetic response variables.
\item \code{z}: A combined data frame of the original and synthetic random effect variables.
\item \code{group}: A combined numeric vector representing the grouping variable for both original and synthetic datasets.
}
}
}
\description{
This function prepares and initializes a catalytic linear mixed model by processing input data,
extracting necessary variables, generating synthetic datasets, and fitting a model.
(Only consider one random effect variance)
}
\examples{
data(mtcars)
cat_init <- cat_lmm_initialization(
  formula = mpg ~ wt + (1 | cyl), # formula for simple model
  data = mtcars,
  x_cols = c("wt"), # Fixed effects
  y_col = "mpg", # Response variable
  z_cols = c("disp", "hp", "drat", "qsec", "vs", "am", "gear", "carb"), # Random effects
  group_col = "cyl", # Grouping column
  syn_size = 100, # Synthetic data size
  resample_by_group = FALSE, # Resampling option
  resample_only = FALSE, # Resampling method
  na_replace = mean # NA replacement method
)
cat_init
}
