% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cayleyR-package.R
\docType{package}
\name{cayleyR-package}
\alias{cayleyR}
\alias{cayleyR-package}
\title{cayleyR: Cayley Graph Analysis for Permutation Puzzles}
\description{
Implements algorithms for analyzing Cayley graphs of permutation groups, with
a focus on the TopSpin puzzle and similar combinatorial problems. Provides
methods for cycle detection, state space exploration, and finding optimal
operation sequences in permutation groups generated by shift and reverse operations.
}
\details{
\subsection{Main Features}{
\itemize{
\item \strong{Basic permutation operations}: cyclic left/right shifts, prefix reversal
\item \strong{Cycle analysis}: find cycles in Cayley graphs with detailed state information
\item \strong{Sequence optimization}: search for operation sequences with maximum cycle length
\item \strong{Fast processing}: lightweight version for batch testing of combinations
}
}

\subsection{Main Functions}{

\strong{Basic Operations:}
\itemize{
\item \code{\link{shift_left}} - Cyclic left shift
\item \code{\link{shift_right}} - Cyclic right shift
\item \code{\link{reverse_prefix}} - Reverse first k elements (turnstile operation)
}

\strong{Analysis Tools:}
\itemize{
\item \code{\link{apply_operations}} - Apply sequence of operations
\item \code{\link{get_reachable_states}} - Full cycle analysis with state tracking
\item \code{\link{get_reachable_states_light}} - Lightweight cycle detection
}

\strong{Optimization:}
\itemize{
\item \code{\link{find_best_random_combinations}} - Find best random sequences
}

After installation from GitHub, visit:
\url{https://github.com/Zabis13/cayleyR}
}
}
\section{Getting Started}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{library(cayleyR)

# Basic operations
shift_left(1:5)
reverse_prefix(1:10, k = 4)

# Cycle analysis for TopSpin 20-4
result <- get_reachable_states(
  start_state = 1:20,
  allowed_positions = c("L", "X"),
  k = 4
)
}\if{html}{\out{</div>}}
}

\references{
\itemize{
\item TopSpin puzzle: \url{https://www.jaapsch.net/puzzles/topspin.htm}
\item Cayley graphs: \url{https://en.wikipedia.org/wiki/Cayley_graph}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/Zabis13/cayleyR}
  \item Report bugs at \url{https://github.com/Zabis13/cayleyR/issues}
}

}
\author{
Yuri Baramykov \href{mailto:lbsbmsu@mail.ru}{lbsbmsu@mail.ru}
}
\keyword{internal}
