% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alt_Witten_CrossValidation.R
\name{Witten.CV}
\alias{Witten.CV}
\title{Sparse CCA by Witten and Tibshirani (2009)}
\usage{
Witten.CV(
  X,
  Y,
  n.cv = 5,
  rank,
  lambdax = matrix(seq(from = 0, to = 1, by = 0.1), nrow = 1),
  lambday = matrix(seq(from = 0, to = 1, by = 0.1), nrow = 1),
  standardize = TRUE
)
}
\arguments{
\item{X}{Matrix of predictors (n x p)}

\item{Y}{Matrix of responses (n x q)}

\item{n.cv}{Number of cross-validation folds (default is 5)}

\item{rank}{Number of canonical components to extract}

\item{lambdax}{Vector of sparsity parameters for X (default is a sequence from 0 to 1 with step 0.1)}

\item{lambday}{Vector of sparsity parameters for Y (default is a sequence from 0 to 1 with step 0.1)}

\item{standardize}{Standardize (center and scale) the data matrices X and Y (default is TRUE) before analysis}
}
\value{
the appropriate levels of regularisation
}
\description{
Sparse CCA by Witten and Tibshirani (2009)
}
