% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_process_cdid.R
\name{pre_process_cdid}
\alias{pre_process_cdid}
\title{Process \code{cdid} Function Arguments}
\usage{
pre_process_cdid(
  yname,
  tname,
  idname,
  gname,
  xformla = NULL,
  data,
  panel = TRUE,
  allow_unbalanced_panel,
  control_group = c("nevertreated", "notyettreated"),
  anticipation = 0,
  weightsname = NULL,
  alp = 0.05,
  bstrap = FALSE,
  cband = FALSE,
  biters = 1000,
  clustervars = NULL,
  est_method = "dr",
  base_period = "varying",
  print_details = FALSE,
  pl = FALSE,
  cores = 1,
  call = NULL
)
}
\arguments{
\item{yname}{The name of the outcome variable}

\item{tname}{The name of the column containing the time periods}

\item{idname}{The individual (cross-sectional unit) id name}

\item{gname}{The name of the variable in \code{data} that
contains the first period when a particular observation is treated.
This should be a positive number for all observations in treated groups.
It defines which "group" a unit belongs to.  It should be 0 for units
in the untreated group.}

\item{xformla}{A formula for the covariates to include in the
model.  It should be of the form \code{~ X1 + X2}.  Default
is NULL which is equivalent to \code{xformla=~1}.  This is
used to create a matrix of covariates which is then passed
to the 2x2 DID estimator chosen in \code{est_method}.
X's are assumed fixed across the time dimension in this version.
Use different columns Xt, Xt+1 if time-varying covariates are needed.}

\item{data}{The name of the data.frame that contains the data}

\item{panel}{(Not used) This is not used as balanced and unbalanced panel data is treated similarly.}

\item{allow_unbalanced_panel}{(Not used) This is not used as balanced and unbalanced panel data is treated similarly.}

\item{control_group}{Which units to use the control group.
The default is "nevertreated" which sets the control group
to be the group of units that never participate in the
treatment.  This group does not change across groups or
time periods.  The other option is to set
\code{group="notyettreated"}.  In this case, the control group
is set to the group of units that have not yet participated
in the treatment in that time period.  This includes all
never treated units, but it includes additional units that
eventually participate in the treatment, but have not
participated yet.}

\item{anticipation}{(Not used) The number of time periods before participating
in the treatment where units can anticipate participating in the
treatment and therefore it can affect their untreated potential outcomes}

\item{weightsname}{The name of the column containing the sampling weights.
If not set, all observations have same weight.}

\item{alp}{the significance level, default is 0.05}

\item{bstrap}{Boolean for whether or not to compute standard errors using
the multiplier bootstrap.  If standard errors are clustered, then one
must set \code{bstrap=TRUE}. Default is \code{TRUE} (in addition, cband
is also by default \code{TRUE} indicating that uniform confidence bands
will be returned.  If bstrap is \code{FALSE}, then analytical
standard errors are reported.}

\item{cband}{Boolean for whether or not to compute a uniform confidence
band that covers all of the group-time average treatment effects
with fixed probability \code{1-alp}.  In order to compute uniform confidence
bands, \code{bstrap} must also be set to \code{TRUE}.  The default is
\code{TRUE}.}

\item{biters}{The number of bootstrap iterations to use.  The default is 1000,
and this is only applicable if \code{bstrap=TRUE}.}

\item{clustervars}{A vector of variables names to cluster on.  At most, there
can be two variables (otherwise will throw an error) and one of these
must be the same as idname which allows for clustering at the individual
level. By default, we cluster at individual level (when \code{bstrap=TRUE}).}

\item{est_method}{the method to compute group-time average treatment effects.  At the moment, one can only use the IPW estimator
with either "2-step" or "Identity" weighting matrix to aggregate Delta ATT into ATT.
include "ipw" for inverse probability weighting and "reg" for
first step regression estimators.}

\item{base_period}{(Not used) The cdid package only uses the g-1 base period for the moment. Whether to use a "varying" base period or a
"universal" base period.  Either choice results in the same
post-treatment estimates of ATT(g,t)'s.  In pre-treatment
periods, using a varying base period amounts to computing a
pseudo-ATT in each treatment period by comparing the change
in outcomes for a particular group relative to its comparison
group in the pre-treatment periods (i.e., in pre-treatment
periods this setting computes changes from period t-1 to period
t, but repeatedly changes the value of t)

A universal base period fixes the base period to always be
(g-anticipation-1).  This does not compute
pseudo-ATT(g,t)'s in pre-treatment periods, but rather
reports average changes in outcomes from period t to
(g-anticipation-1) for a particular group relative to its comparison
group.  This is analogous to what is often reported in event
study regressions.

Using a varying base period results in an estimate of
ATT(g,t) being reported in the period immediately before
treatment.  Using a universal base period normalizes the
estimate in the period right before treatment (or earlier when
the user allows for anticipation) to be equal to 0, but one
extra estimate in an earlier period.}

\item{print_details}{Whether or not to show details/progress of computations.
Default is \code{FALSE}.}

\item{pl}{Whether or not to use parallel processing}

\item{cores}{The number of cores to use for parallel processing}

\item{call}{(Not used) a call control var}
}
\value{
a \code{\link{DIDparams}} object
}
\description{
Function to process arguments passed to the main methods in the
\code{cdid} package as well as conducting some tests to ensure
data is in proper format and provides helpful error messages.
}
\references{
Bellego, Benatia, and Dortet-Bernadet (2024), "The Chained Difference-in-Differences",
Journal of Econometrics, https://doi.org/10.1016/j.jeconom.2023.11.002.
}
