% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paK.R
\name{paK}
\alias{paK}
\title{Parallel analysis - dimensionality assessment method}
\usage{
paK(
  dat,
  R = 100,
  fa = "pc",
  cor = "both",
  cutoff = "mean",
  fm = "uls",
  plot = TRUE,
  verbose = TRUE,
  seed = NULL
)
}
\arguments{
\item{dat}{A \emph{N} individuals x \emph{J} items (\code{matrix} or \code{data.frame}). Missing values need to be coded as \code{NA}.}

\item{R}{Number of resampled datasets (i.e., replications) to generate. The default is 100.}

\item{fa}{Extraction method to use. It includes \code{"pc"} (for principal components analysis), \code{"fa"} (for principal axis factor analysis), and \code{"both"}. The default is \code{"pc"}.}

\item{cor}{What type of correlations to use. It includes \code{"cor"} (for Pearson correlations), \code{"tet"} (for tetrachoric/polychoric correlations), and \code{"both"}. The default is \code{"both"}.}

\item{cutoff}{What criterion to use as the cutoff. It can be \code{"mean"} (for the average generated eigenvalues) or a value between 0 and 100 (for a percentile). A vector with several criteria can be used. The default is \code{"mean"}.}

\item{fm}{Factoring method to use. It includes \code{"uls"} (for unweighted least squares), \code{"ml"} (for maximum likelihood), and \code{"wls"} (for weighted least squares), among others. The default is \code{"uls"}.}

\item{plot}{Print the parallel analysis plot? Note that the plot might be messy if many variants are requested. The default is \code{TRUE}.}

\item{verbose}{progress. The default is \code{TRUE}.}

\item{seed}{A seed for obtaining consistent results. If \code{NULL}, no seed is used. The default is \code{NULL}.}
}
\value{
\code{paK} returns an object of class \code{paK}.
\describe{
\item{\code{sug.K}}{The suggested number of attributes for each variant (\code{vector}).}
\item{\code{e.values}}{The sample and reference eigenvalues (\code{matrix}).}
\item{\code{plot}}{The parallel analysis plot. Only if \code{plot = TRUE} (\code{plot}).}
\item{\code{specifications}}{Function call specifications (\code{list}).}
}
}
\description{
Parallel analysis with column permutation (i.e., resampling) as used in Nájera, Abad, & Sorrel (2021).
It is recommended to use principal components, Pearson correlations, and mean criterion (Garrido, Abad, & Ponsoda, 2013; Nájera, Abad, & Sorrel, 2021).
The parallel analysis based on principal axis factor analysis is conducted using the \code{fa.parallel} function of the \code{psych} R package (Revelle, 2020).
The tetrachoric correlations are efficiently estimated using the \code{sirt} R package (Robitzsch, 2020).
The graph is made with the \code{ggplot2} package (Wickham et al., 2020).
}
\examples{
library(GDINA)
dat <- sim30GDINA$simdat
Q <- sim30GDINA$simQ
# In paK, R = 100 is recommended (R = 30 is here used for illustration purposes)
pa.K <- paK(dat = dat, R = 30, fa = "pc", cutoff = c("mean", 95), plot = TRUE, seed = 123)
pa.K$sug.K # Check suggested number of attributes by each parallel analysis variant
pa.K$e.values # Check eigenvalues
pa.K$plot # Show parallel analysis plot
}
\references{
Garrido, L. E., Abad, F. J., & Ponsoda, V. (2013). A new look at Horn's parallel analysis with ordinal variables. \emph{Psychological Methods}, \emph{18}, 454-474. https://doi.org/10.1037/a0030005

Nájera, P., Abad, F. J., & Sorrel, M. A. (2021). Determining the number of attributes in cognitive diagnosis modeling. \emph{Frontiers in Psychology}, \emph{12}:614470. https://doi.org/10.3389/fpsyg.2021.614470

Revelle, W. (2019). \emph{psych: Procedures for Psychological, Psychometric, and Personality Research}. R package version 1.9.12. https://CRAN.R-project.org/package=psych.

Robitzsch, A. (2020). \emph{sirt: Supplementary Item Response Theory Models}. R package version 3.9-4. https://CRAN.R-project.org/package=sirt.

Wickham, H., et al. (2020). \emph{ggplot2: Create Elegant Data Visualisations Using the Grammar of Graphics}. R package version 3.3.2. https://CRAN.R-project.org/package=ggplot2.
}
\author{
{Pablo Nájera, Universidad Pontificia Comillas \cr Miguel A. Sorrel, Universidad Autónoma de Madrid \cr Francisco J. Abad, Universidad Autónoma de Madrid}
}
