% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personFit.R
\name{personFit}
\alias{personFit}
\title{Calculate standardized log-likelihood statistic (lZ) for person fit evaluation}
\usage{
personFit(fit, att.est = "MLE", sig.level = 0.05, p.adjust.method = "BH")
}
\arguments{
\item{fit}{An object of class \code{RDINA} or \code{GDINA} (Ma & de la Torre, 2020).}

\item{att.est}{What attribute estimates are used? The default is \code{"MLE"}.}

\item{sig.level}{Scalar numeric. Alpha level for decision. Default is 0.05.}

\item{p.adjust.method}{Scalar character. Correction method for p-values. Possible values include "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", and "none". See p.adjust function from the stats R package for additional details. Default is BH.}
}
\value{
\code{personFit} returns an object of class \code{personFit}, with a list of elements:
\describe{
\item{\code{stat}}{Person fit statistics (\code{data.frame}).}
\item{\code{p}}{p-values (two-sided test) for the person fit statistics (\code{data.frame}).}
\item{\code{sigp}}{Scalar vectors denoting the examinees for which the person fit statitic is significant (p-value) (\code{list}).}
\item{\code{sigadjp}}{Scalar vectors denoting the examinees for which the person fit statitic is significant (adjusted p-value) (\code{list}).}
}
}
\description{
This function calculates the standardized log-likelihood statistic (lZ; Cui & Li, 2015; Drasgow et al. 1985) and the proposals for correcting its distribution discussed in Santos et al. (2019).
}
\examples{
\donttest{
library(GDINA)
dat <- sim10GDINA$simdat[1:20, ]
Q <- sim10GDINA$simQ
fit <- GDINA(dat = dat, Q = Q, model = "GDINA")
res.personFit <- personFit(fit)
res.personFit
}
}
\references{
Cui, Y., & Li, J. (2015). Evaluating person fit for cognitive diagnostic assessment. \emph{Applied Psychological Measurement}, \emph{39}, 223–238. https://doi.org/10.1177/0146621614557272

Drasgow, F., Levine, M. V., & Williams, E. A. (1985). Appropriateness measurement with polychotomous item response models and standardized indices. \emph{British Journal of Mathematical and Statistical Psychology}, \emph{38}, 67–86. https://psycnet.apa.org/doi/10.1111/j.2044-8317.1985.tb00817.x

Santos, K. C. P., de la Torre, J., & von Davier, M. (2020). Adjusting person fit index for skewness in cognitive diagnosis modeling. \emph{Journal of Classification}, \emph{37}, 399-420. https://doi.org/10.1007/s00357-019-09325-5
}
\author{
{Miguel A. Sorrel, Universidad Autónoma de Madrid, \cr Kevin Santos, University of the Philippines, \cr Pablo Nájera, Universidad Pontificia Comillas}
}
