% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atp_plot.R
\name{atp_plot}
\alias{atp_plot}
\title{ATP Plot}
\usage{
atp_plot(
  energetics,
  model = "ols",
  error_bar = "ci",
  conf_int = 0.95,
  size = 2,
  shape = 16,
  basal_vs_max = "basal",
  glyc_vs_resp = "glyc",
  group_label = "Experimental group",
  sep_reps = FALSE,
  ci_method = "Wald"
)
}
\arguments{
\item{energetics}{A table of calculated glycolysis and OXPHOS rates.
Returned by \code{get_energetics}}

\item{model}{The linear model used to estimate mean and confidence
intervals: ordinary least squares (\code{"ols"}) or mixed-effects (\code{"mixed"})}

\item{error_bar}{Whether to plot error bars as standard deviation (\code{"sd"})
or confidence intervals (\code{"ci"})}

\item{conf_int}{The confidence interval percentage. Should be between 0 and 1}

\item{size}{Size of the points}

\item{shape}{Shape of the points}

\item{basal_vs_max}{Whether to plot \code{"basal"} or \code{"max"} respiration}

\item{glyc_vs_resp}{Whether to plot glycolysis (\code{"glyc"})  or respiration (\code{"resp"})}

\item{group_label}{Label for the experimental group to populate the legend title}

\item{sep_reps}{Whether to calculate summary statistics on the groups with
replicates combined. The current default \code{FALSE} combines replicates, but
future releases will default to \code{TRUE} providing replicate-specific
summaries.}

\item{ci_method}{The method used to compute confidence intervals for the
mixed-effects model: \code{"Wald"}, \code{"profile"}, or \code{"boot"} passed to
\code{lme4::confint.merMod()}.}
}
\value{
a ggplot
}
\description{
Generate the ATP Plot
}
\details{
\strong{Note:}
When we use the term 'max' in the package documentation we mean the maximal
experimental OCR and ECAR values rather than absolute biological maximums.
}
\examples{
rep_list <- system.file("extdata", package = "ceas") |>
  list.files(pattern = "*.xlsx", full.names = TRUE)
seahorse_rates <- read_data(rep_list, sheet = 2)
partitioned_data <- partition_data(seahorse_rates)
energetics <- get_energetics(
  partitioned_data,
  ph = 7.4,
  pka = 6.093,
  buffer = 0.1
)
atp_plot(energetics, sep_reps = FALSE)

atp_plot(energetics, basal_vs_max = "max", sep_reps = FALSE)

atp_plot(
  energetics,
  basal_vs_max = "basal",
  glyc_vs_resp = "resp",
  sep_reps = TRUE
)
# to change fill, the geom_point shape number should be between 15 and 25
atp_plot(
  energetics,
  sep_reps = FALSE
) +
  ggplot2::scale_fill_manual(
    values = c("#e36500", "#b52356", "#3cb62d", "#328fe1")
  )

# to change color, use ggplot2::scale_color_manual
atp_plot(energetics, sep_reps = FALSE) +
  ggplot2::scale_color_manual(
    values = c("#e36500", "#b52356", "#3cb62d", "#328fe1")
  )
}
