% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ce-uccs.R
\name{ce_uccs}
\alias{ce_uccs}
\title{Find UCCs for expenditure categories}
\usage{
ce_uccs(hg, expenditure = NULL, ucc_group = NULL, uccs_only = TRUE)
}
\arguments{
\item{hg}{A data frame that has, at least, the title, level, and ucc
columns of a CE HG file.}

\item{expenditure}{A string that is an expenditure category contained in a
CE HG file (exact match required). Either expenditure or ucc_group is
required. The default is NULL.}

\item{ucc_group}{A string indicating an expenditure category by UCC group in
a CE HG file (exact match required). Either expenditure or ucc_group is
required. The default is NULL.}

\item{uccs_only}{A logical indicating whether to return only the expenditure
category's component ucc's. If TRUE (default), a vector of UCC's will be
returned. If FALSE, a dataframe will be returned containing the section of
the HG file containing the expenditure category and its component sub-
categories}
}
\value{
A vector of Universal Classification Codes (UCC's) corresponding to
the lowest hierarchical level for that category.
}
\description{
Find UCCs for expenditure categories
}
\details{
If both a valid expenditure and valid ucc_group are input, ucc_group
will be used.
}
\examples{
\dontrun{
# First generate an HG file
my_hg <- ce_hg(2021, interview, hg_file_path = "CE-HG-Inter-2021.txt")

# Store a vector of UCC's in the "Pets" category
pet_uccs <- ce_uccs(my_hg, "Pets")
pet_uccs
# [1] "610320" "620410" "620420"
}
}
