% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ces-package.R
\docType{package}
\name{ces-package}
\alias{ces}
\alias{ces-package}
\title{Canadian Election Study Data Package}
\description{
Provides tools to easily access and analyze Canadian Election Study data.
The package simplifies the process of downloading, cleaning, and using CES datasets
for political science research and analysis. The Canadian Election Study (CES)
has been conducted during federal elections since 1965, surveying Canadians
on their political preferences, engagement, and demographics.
}
\section{Key Functions}{

\itemize{
\item \code{\link{get_ces}}: Download and load CES data for a specific year
\item \code{\link{list_ces_datasets}}: List available CES datasets
\item \code{\link{get_ces_subset}}: Get a subset of variables from a CES dataset
\item \code{\link{create_codebook}}: Generate a comprehensive codebook for CES datasets
\item \code{\link{download_pdf_codebook}}: Download official PDF codebooks
\item \code{\link{download_ces_dataset}}: Download a single CES dataset
\item \code{\link{download_all_ces_datasets}}: Download all CES datasets
}
}

\section{Data Sources}{

Data is accessed from multiple sources including the Borealis Data repository (the primary
institutional repository for most CES datasets) and the official Canadian Election Study
website. This package is not officially affiliated with the Canadian Election Study,
Borealis Data, or the University of British Columbia, and users should cite the original
data sources in their work.
}

\references{
For more information about the Canadian Election Study, visit:
\url{https://ces-eec.arts.ubc.ca/}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/laurenceomfoisy/ces}
  \item Report bugs at \url{https://github.com/laurenceomfoisy/ces/issues}
}

}
\author{
Laurence-Olivier M. Foisy
}
\keyword{package}
