% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POR.R
\name{POR}
\alias{POR}
\title{Compute Percent of Time Outside Range}
\usage{
POR(df, sd = 1, sr = 5)
}
\arguments{
\item{df}{Data frame read through readfile}

\item{sd}{Standard deviation indicating glycemic excursion, default = 1}

\item{sr}{Sampling rate inverse in minutes of the CGM (default is
Dexcom -> 5 minutes)}
}
\value{
A numeric value representing POR
}
\description{
This function computes the percent of time outside range
(range in standard deviations from mean, default = 1).
}
\examples{
mydatafile <- system.file("extdata", "my_data_file.csv", package = "cgmquantify")
mydata <- readfile(mydatafile)
POR(mydata, sd = 1, sr = 5)
}
