% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HD_covariance.R
\name{BS.cov}
\alias{BS.cov}
\title{Binary Segmentation for covariance change points detection through Operator Norm.}
\usage{
BS.cov(X, s, e, level = 0)
}
\arguments{
\item{X}{A \code{numeric} matrix of observations with with horizontal axis being time, and vertical axis being dimensions.}

\item{s}{A \code{integer} scalar of starting index.}

\item{e}{A \code{integer} scalar of ending index.}

\item{level}{A parameter for tracking the level at which a change point is detected. Should be fixed as 0.}
}
\value{
An object of \code{\link[base]{class}} "BS", which is a \code{list} with the structure:
\itemize{
 \item S:           A vector of estimated changepoints (sorted in strictly increasing order).
 \item Dval:        A vector of values of CUSUM statistic based on KS distance.
 \item Level:       A vector representing the levels at which each change point is detected.
 \item Parent:      A matrix with the starting indices on the first row and the ending indices on the second row.
}
}
\description{
Perform binary segmentation for covariance change points detection through Operator Norm.
}
\examples{
p = 10
A1 = gen.cov.mat(p, 1, "equal")
A2 = gen.cov.mat(p, 2, "diagonal")
A3 = gen.cov.mat(p, 3, "power")
X = cbind(t(MASS::mvrnorm(100, mu = rep(0, p), A1)), 
          t(MASS::mvrnorm(150, mu = rep(0, p), A2)), 
          t(MASS::mvrnorm(200, mu = rep(0, p), A3)))
temp = BS.cov(X, 1, 450)
thresholdBS(temp, 10)
}
\references{
Wang, Yu and Rinaldo (2021) <doi:10.3150/20-BEJ1249>.
}
\seealso{
\code{\link{thresholdBS}} for obtain change points estimation.
}
\author{
Haotian Xu
}
