% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HD_regression.R
\name{LRV.regression}
\alias{LRV.regression}
\title{Long-run variance estimation for regression settings with change points.}
\usage{
LRV.regression(cpt_init, beta_hat, y, X, w = 0.9, block_size)
}
\arguments{
\item{cpt_init}{An \code{integer} vector of initial changepoints estimation (sorted in strictly increasing order).}

\item{beta_hat}{A \code{numeric} (px(K_hat+1))matrix of estimated regression coefficients.}

\item{y}{A \code{numeric} vector of response variable.}

\item{X}{A \code{numeric} matrix of covariates with vertical axis being time.}

\item{w}{A \code{numeric} scalar in (0,1) representing the weight for interval truncation.}

\item{block_size}{An \code{integer} scalar corresponding to the block size S in the paper.}
}
\value{
A vector of long-run variance estimators associated with all local refined intervals.
}
\description{
Estimating long-run variance for regression settings with change points.
}
\examples{
d0 = 5
p = 10
n = 200
cpt_true = c(70, 140)
data = simu.change.regression(d0, cpt_true, p, n, sigma = 1, kappa = 9)
lambda_set = c(0.1, 0.5, 1, 2)
zeta_set = c(10, 15, 20)
temp = CV.search.DPDU.regression(y = data$y, X = data$X, lambda_set, zeta_set)
temp$test_error # test error result
# find the indices of lambda_set and zeta_set which minimizes the test error
min_idx = as.vector(arrayInd(which.min(temp$test_error), dim(temp$test_error))) 
lambda_set[min_idx[2]]
zeta_set[min_idx[1]]
cpt_init = unlist(temp$cpt_hat[min_idx[1], min_idx[2]])
beta_hat = matrix(unlist(temp$beta_hat[min_idx[1], min_idx[2]]), ncol = length(cpt_init)+1)
interval_refine = trim_interval(n, cpt_init)
# choose S
block_size = ceiling(sqrt(min(floor(interval_refine[,2]) - ceiling(interval_refine[,1])))/2)
LRV_est = LRV.regression(cpt_init, beta_hat, data$y, data$X, w = 0.9, block_size)
}
\references{
Xu, Wang, Zhao and Yu (2022) <arXiv:2207.12453>.

Xu, Wang, Zhao and Yu (2022) <arXiv:2207.12453>.
}
\author{
Haotian Xu
}
