% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartreview.r
\name{makeplot}
\alias{makeplot}
\title{Generate plots on confidence intervals and prediction}
\usage{
makeplot(
  dataset2,
  dat2,
  optionCI = 1,
  stopCI = NULL,
  alpha = 0.05,
  stoppingoption = 2,
  xlim = NULL,
  ylim = NULL,
  main = NULL,
  makePlot = TRUE
)
}
\arguments{
\item{dataset2}{The output dataset of the function 'fullrun'.}

\item{dat2}{Second dataset on which confidence intervals are computed, see function 'fullrun'.}

\item{optionCI}{Parameter to switch between confidence intervals (1 for Lai's confidence bands, 2 for Bayesian credible intervals, 3 for normal confidence intervals).}

\item{stopCI}{The stopping bounds.}

\item{alpha}{The error used to compute confidence bands.}

\item{stoppingoption}{Type of stopping criterion (1 for confidence interval included in stopCI, 2 for upper bound below or lower bound above stopCI, 3 for length restriction on confidence interval).}

\item{xlim}{Optional parameter to set x-axis in plots.}

\item{ylim}{Optional parameter to set y-axis in plots.}

\item{main}{Optional parameter to set title of plots.}

\item{makePlot}{Parameter to control plot output.}
}
\value{
List with confidence intervals (slot CIs), the stopping point (slot stopline), and the reason for stopping (stopreason, see function 'stoppingcriterion').
}
\description{
Generate plots on confidence intervals and prediction
}
\examples{
require(chartreview)

}
\references{
.
}
