% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace.R
\name{replace}
\alias{replace}
\alias{replace_}
\title{Fast vector replacement, an alternative to \verb{[<-}}
\usage{
replace_(x, where, with, in_place = FALSE, quiet = FALSE)
}
\arguments{
\item{x}{A vector.}

\item{where}{\verb{[integer(n)]} - Where to assign replacement values. This can
be an integer vector of locations, a logical vector (passed to \code{which_()}),
or a character vector of names.}

\item{with}{Replacement values. These will be recycled against the
resulting \code{where} integer locations.}

\item{in_place}{\verb{[logical(1)]} - Should assignment be done in-place
(no copies)? Default is \code{FALSE}. Please note that assignment will occur
in-place where possible even if \code{in_place} is set to \code{FALSE}.}

\item{quiet}{Should warnings be suppressed when \code{in_place = TRUE} and \code{x}
is shared my multiple objects? Default is \code{FALSE}.}
}
\value{
A vector whose values are
replaced with \code{with} at locations specified by \code{where}.
}
\description{
Fast vector replacement, an alternative to \verb{[<-}
}
\examples{
library(cheapr)

x <- set_round(seq_(-2, 2, by = 0.5))

x |>
  replace_(1, with = 100) # Assign value 100 at location 1

# Base R casts to `x` and replacement to a common type
`[<-`(x, x== 0, "42")

# `assign_at` only casts replacement to type of x
x |>
  replace_(x == 0, with = "42") # Assign value 42 where x == 0

}
