% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{as_sarif_json.checkglobals}
\alias{as_sarif_json.checkglobals}
\title{Cast to SARIF json}
\usage{
\method{as_sarif_json}{checkglobals}(x, path, pattern, which = c("global", "import"), ...)
}
\arguments{
\item{x}{object inheriting from class \code{"checkglobals"}.}

\item{path}{(optional) file path to write the SARIF json content. If missing, the SARIF
content is returned as an object of class \code{json}.}

\item{pattern}{an optional \link{regular expression}.  Only names
matching \code{pattern} are returned. \code{\link{glob2rx}} can be
used to convert wildcard patterns to regular expressions.}

\item{which}{a character vector, either \code{"global"} to print all unrecognized global variables,
\code{"import"} to print all detected imported functions and variables, or both (default).}

\item{...}{additional arguments to configure the output:
\itemize{
\item \code{all.names}, a logical value. If \code{TRUE}, all object names are returned.
If \code{FALSE}, names which begin with a \samp{.} are omitted. Defaults to \code{TRUE}.
\item \code{pretty}, a logical value passed to \code{jsonlite::toJSON}. Defaults to \code{FALSE}.
\item \code{root_dir}, directory to use as root relative to which all result uri's are generated.
\item \code{use_cli}, a logical value indicating if \code{cli} should be used to format the result messages.
Defaults to \code{TRUE}, which means that \code{cli}-formatting is attempted if \code{cli} is installed.
\item \code{markdown}, a logical value indicating if \code{markdown} result fields should be included.
 Defaults to \code{FALSE}.
\item \code{first_only}, a logical value to include only the first detected location of an unknown
global variable or function (instead of all detected locations). Defaults to \code{FALSE}.
}}
}
\value{
if \code{path} is provided writes the SARIF json content to \code{path} and
returns the \code{path} invisibly, otherwise returns the SARIF json content as a \code{json} object..
}
\description{
Cast an S3-object of class \code{"checkglobals"} to SARIF json.
}
\examples{
## R-package from folder
chk <- checkglobals(
  pkg = system.file(
    "unit_tests", "pkg", "testpkg",
    package = "checkglobals"
  )
)
json <- as_sarif_json(chk, pretty = TRUE, markdown = TRUE)
}
