% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantifiers.R
\name{at_least}
\alias{at_least}
\title{Facilitate "At Least" Comparison on Logical Vectors}
\usage{
at_least(logical_vec, p = NULL, n = NULL, na.rm = FALSE)
}
\arguments{
\item{logical_vec}{A logical vector.}

\item{p}{Proportion value (0 to 1) to compare against.}

\item{n}{Count value (integer) to compare against.}

\item{na.rm}{Logical. Should missing values be removed before calculation?}
}
\value{
\code{TRUE} if the condition is met for at least the specified
proportion or count, otherwise \code{FALSE}.
}
\description{
This function facilitates a comparison to check if at least a specified
proportion or count of values in a logical vector evaluate to \code{TRUE}.
}
\examples{
# Check if at least 50\% of values are TRUE
at_least(c(TRUE, TRUE, FALSE), p = 0.5) # Returns TRUE

}
\seealso{
Other basic_quantifiers: 
\code{\link{at_most}()},
\code{\link{exactly_equal}()},
\code{\link{less_than}()},
\code{\link{more_than}()}
}
\concept{basic_quantifiers}
