% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPCTable.R
\name{NPCTable}
\alias{NPCTable}
\title{Generate NPClassifier classification}
\usage{
NPCTable(compoundData)
}
\arguments{
\item{compoundData}{Data frame with the chemical compounds of interest,
usually the compounds found in the sample dataset.
Should include a column named "compound" with common names of
the compounds and a column named "smiles" with SMILES IDs of the compounds.}
}
\value{
Data frame with the NPClassifier classification for each compound
as pathway, superclass and class. Note that compounds may be classified
in more than one group, or no group, at each level of classification.
}
\description{
Function to classify compounds with \emph{NPClassifier}, and put the results in
a data frame containing the pathway, superclass and class for each compound.
}
\details{
\emph{NPClassifier} (Kim et al. 2021) is a deep-learning tool that automatically
classifies natural products (i.e. phytochemical compounds) into a
hierarchical classification of three levels: pathway, superclass and class.
This classification largely corresponds to the biosynthetic groups/pathways
the compounds are produced in. The \code{NPCTable} function
conveniently performs this classification directly in R on the
compounds in \code{compoundData}, by accessing the tool
at \url{https://npclassifier.gnps2.org/} and downloading the classifications.
}
\examples{
data(minimalCompData)
NPCTable(minimalCompData)

data(alpinaCompData)
NPCTable(compoundData = alpinaCompData[1:3,]) # First three compounds only
}
\references{
Kim HW, Wang M, Leber CA, Nothias L-F, Reher R, Kang KB,
van der Hooft JJJ, Dorrestein PC, Gerwick WH, Cottrell GW. 2021.
NPClassifier: A Deep Neural Network-Based Structural Classification
Tool for Natural Products. Journal of Natural Products 84: 2795-2807.
}
