% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key_functions.R
\name{trim_key}
\alias{trim_key}
\title{Modify the names in a conversion key to only include the first word}
\usage{
trim_key(key)
}
\arguments{
\item{key}{the key to trim}
}
\value{
the key that was trimmed (a named list of 3 named lists)
}
\description{
For parenteral (sai) and long-acting/depot (lai) antipsychotics, the name 
consists of the usual generic name (such as haloperidol) and a second word
describing the formulation (e.g. haloperidol decanoate). Since to_cpz() and
add_key() require exact matches to work properly, removing the second word
may be required, but should be done with care as it can add ambiguity (e.g.
fluphenazine enanthate and decanoate).
}
\examples{
trim_key(gardner2010)
}
\seealso{
Other key functions: 
\code{\link{add_key}()},
\code{\link{check_key}()}
}
\concept{key functions}
