% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_chemstation_ch.R
\name{read_chemstation_ch}
\alias{read_chemstation_ch}
\title{Read 'Agilent ChemStation' CH files}
\usage{
read_chemstation_ch(
  path,
  format_out = c("matrix", "data.frame", "data.table"),
  data_format = c("wide", "long"),
  read_metadata = TRUE,
  metadata_format = c("chromconverter", "raw"),
  scale = TRUE
)
}
\arguments{
\item{path}{Path to 'Agilent' \code{.ch} file.}

\item{format_out}{Class of output. Either \code{matrix}, \code{data.frame},
or \code{data.table}.}

\item{data_format}{Whether to return data in \code{wide} or \code{long} format.}

\item{read_metadata}{Logical. Whether to attach metadata. Defaults to \code{TRUE}.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter}
or \code{raw}.}

\item{scale}{Whether to scale the data by the scaling factor present in the
file. Defaults to \code{TRUE}. 'MassHunter' seems to ignore the scaling
factor in at least some types of 'ChemStation' files.}
}
\value{
A 2D chromatogram in the format specified by \code{data_format} and
\code{format_out}. If \code{data_format} is \code{wide}, the chromatogram will
be returned with retention times as rows and a single column for the intensity.
If \code{long} format is requested, two columns will be returned: one for the
retention time and one for the intensity. The \code{format_out} argument
determines whether the chromatogram is returned as a \code{matrix},
\code{data.frame}, or \code{data.table}. Metadata can be attached to the
chromatogram as \code{\link{attributes}} if \code{read_metadata} is \code{TRUE}.
}
\description{
Reads 'Agilent ChemStation' \code{.ch} files.
}
\details{
'Agilent' \code{.ch} files come in several different formats. This parser
can automatically detect and read several versions of these files from
'Agilent ChemStation' and 'Agilent OpenLab', including versions \code{30} and
\code{130}, which are generally produced by ultraviolet detectors, as well as
\code{81}, \code{179}, and \code{181} which are generally produced by flame
ionization (FID) detectors.
}
\note{
This function was adapted from the
\href{https://github.com/chemplexity/chromatography}{Chromatography Toolbox}
(© James Dillon 2014).
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
read_chemstation_ch("tests/testthat/testdata/chemstation_130.ch")
\dontshow{\}) # examplesIf}
}
\seealso{
Other 'Agilent' parsers: 
\code{\link{read_agilent_d}()},
\code{\link{read_agilent_dx}()},
\code{\link{read_chemstation_csv}()},
\code{\link{read_chemstation_ms}()},
\code{\link{read_chemstation_reports}()},
\code{\link{read_chemstation_uv}()}
}
\author{
Ethan Bass
}
\concept{'Agilent' parsers}
