% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccBarplot}
\alias{ccBarplot}
\title{Draw barplots}
\usage{
ccBarplot(
  value,
  pos,
  bar_width = 0.6,
  col = NA,
  border = "black",
  lwd = par("lwd"),
  lty = par("lty")
)
}
\arguments{
\item{value}{A numeric vector or a matrix. If it is a matrix, columns correspond to the height of bars.}

\item{pos}{Positions of the bars.}

\item{bar_width}{Width of bars. It assumes the bars locating at \code{x = 1, 2, ...}.}

\item{col}{Filled color of bars.}

\item{border}{Color for the border.}

\item{lwd}{Line width.}

\item{lty}{Line style.}
}
\value{
Object \linkS4class{ccCellGeom}
}
\description{
Object \linkS4class{ccCellGeom} will call the function \link[circlize:circos.barplot]{circlize::circos.barplot} while drawing.
}
\examples{
library(circlizePlus)
cc <- ccPlot(sectors = letters[1:4], xlim = c(0, 10))
track <- ccTrack(ylim = c(0, 1))
cell <- ccCell(sector.index = "a") + ccBarplot(value = runif(10), pos = 1:10 - 0.5, col = 1:10)
track <- track + cell
cc + track
}
