% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{ccGenomicLink}
\alias{ccGenomicLink}
\title{Add links between two sets of genomic positions}
\usage{
ccGenomicLink(
  region1,
  region2,
  rou = NULL,
  rou1 = rou,
  rou2 = rou,
  col = "black",
  lwd = par("lwd"),
  lty = par("lty"),
  border = col,
  ...
)
}
\arguments{
\item{region1}{A data frame in bed format.
}

\item{region2}{A data frame in bed format.
}

\item{rou}{Pass to \code{\link[circlize]{circos.link}}.
}

\item{rou1}{Pass to \code{\link[circlize]{circos.link}}.
}

\item{rou2}{Pass to \code{\link[circlize]{circos.link}}.
}

\item{col}{Pass to \code{\link[circlize]{circos.link}}, length can be either one or nrow of \code{region1}.
}

\item{lwd}{Pass to \code{\link[circlize]{circos.link}}, length can be either one or nrow of \code{region1}.
}

\item{lty}{Pass to \code{\link[circlize]{circos.link}}, length can be either one or nrow of \code{region1}.
}

\item{border}{Pass to \code{\link[circlize]{circos.link}}, length can be either one or nrow of \code{region1}.
}

\item{...}{Pass to \code{\link[circlize]{circos.link}}.
}
}
\value{
Object \linkS4class{ccGenomicLink}
}
\description{
Object \linkS4class{ccGenomicLink} will call the function \link[circlize:circos.genomicLink]{circlize::circos.genomicLink} while drawing.
}
\examples{
\donttest{
library(circlizePlus)
set.seed(123)

bed1 = generateRandomBed(nr = 100)
bed1 = bed1[sample(nrow(bed1), 20), ]
bed2 = generateRandomBed(nr = 100)
bed2 = bed2[sample(nrow(bed2), 20), ]
par1 = ccPar("track.height" = 0.1, cell.padding = c(0, 0, 0, 0))
cc = ccPlot(initMode="initializeWithIdeogram")

link1 = ccGenomicLink(bed1, bed2, col = sample(1:5, 20, replace = TRUE), border = NA)
cc + par1 + link1
}
}
