% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{ccLink}
\alias{ccLink}
\title{Add a link}
\usage{
ccLink(
  sector.index1,
  point1,
  sector.index2,
  point2,
  rou = NULL,
  rou1 = rou,
  rou2 = rou,
  h = NULL,
  h.ratio = 0.5,
  w = 1,
  h2 = h,
  w2 = w,
  inverse = FALSE,
  col = "black",
  lwd = par("lwd"),
  lty = par("lty"),
  border = col,
  directional = 0,
  arr.length = ifelse(arr.type == "big.arrow", 0.02, 0.4),
  arr.width = arr.length/2,
  arr.type = "triangle",
  arr.lty = lty,
  arr.lwd = lwd,
  arr.col = col,
  reduce_to_mid_line = FALSE
)
}
\arguments{
\item{sector.index1}{Index for the first sector where one link end locates
}

\item{point1}{A single value or a numeric vector of length 2. If it is a 2-elements vector, then
 the link would be a belt/ribbon.
}

\item{sector.index2}{Index for the other sector where the other link end locates
}

\item{point2}{A single value or a numeric vector of length 2. If it is a 2-elements vector, then
 the link would be a belt/ribbon.
}

\item{rou}{The position of the the link ends (if \code{rou1} and \code{rou2} are not set). It is the percentage of the radius of the unit circle.
 By default its value is the position of bottom margin of the most inner track.
}

\item{rou1}{The position of end 1 of the link.
}

\item{rou2}{The position of end 2 of the link.
}

\item{h}{Height of the link, measured as percent to the radius to the unit circle. By default it is automatically infered.
}

\item{h.ratio}{systematically change the link height. The value is between 0 and 1.
}

\item{w}{Since the link is a Bezier curve, it controls the shape of Bezier curve.
}

\item{h2}{Height of the bottom edge of the link if it is a ribbon.
}

\item{w2}{Shape of the bottom edge of the link if it is a ribbon.
}

\item{inverse}{Whether the link is inversed.
}

\item{col}{Color of the link. If the link is a ribbon, then it is the filled color for the ribbon.
}

\item{lwd}{Line (or border) width
}

\item{lty}{Line (or border) style
}

\item{border}{If the link is a ribbon, then it is the color for the ribbon border.
}

\item{directional}{0 for no direction, 1 for direction from \code{point1} to \code{point2}, -1 for direction from \code{point2} to \code{point1}.
 2 for two directional. The direction is important when arrow heads are added.
}

\item{arr.length}{Length of the arrows, measured in 'cm', pass to \code{\link[shape]{Arrowhead}}. If \code{arr.type} is set to \code{big.arrow},
 the value is percent to the radius of the unit circle.
}

\item{arr.width}{Width of the arrows, pass to \code{\link[shape]{Arrowhead}}.
}

\item{arr.type}{Type of the arrows, pass to \code{\link[shape]{Arrowhead}}. Default value is \code{triangle}. There is an additional option
 \code{big.arrow}.
}

\item{arr.lty}{Line type of arrows, pass to \code{\link[shape]{Arrowhead}}.
}

\item{arr.lwd}{Line width of arrows, pass to \code{\link[shape]{Arrowhead}}.
}

\item{arr.col}{Color of the arrows, pass to \code{\link[shape]{Arrowhead}}.
}

\item{reduce_to_mid_line}{Only use the middle points of \code{point1} and \code{point2} to draw the link.
}
}
\value{
Object \linkS4class{ccLink}
}
\description{
Object \linkS4class{ccLink} will call the function \link[circlize:circos.link]{circlize::circos.link} while drawing.
}
\examples{
library(circlizePlus)
set.seed(999)
n = 1000
df = data.frame(sectors = sample(letters[1:8], n, replace = TRUE),x = rnorm(n), y = runif(n))
cc = ccPlot(initMode = "initialize", sectors = df$sectors, x = df$x)
track1 = ccTrack(df$sectors, y = df$y)
col = rep(c("#FF0000", "#00FF00"), 4)
tPoint1 = ccTrackPoints(df$sectors, df$x, df$y, col = col, pch = 16, cex = 0.5)
link1 = ccLink("a", 0, "b", 0, h = 0.4)
link2 = ccLink("c", c(-0.5, 0.5), "d", c(-0.5,0.5), col = "red",border = "blue", h = 0.2)
link3 = ccLink("e", 0, "g", c(-1,1), col = "green", border = "black", lwd = 2, lty = 2)
cc + (track1 + tPoint1) + link1 + link2 + link3
}
