% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ContextualInfluence.R
\name{ciu.ggplot.contrastive}
\alias{ciu.ggplot.contrastive}
\title{Create contrastive ggplot}
\usage{
ciu.ggplot.contrastive(
  ciu.meta.result,
  contrastive.influences,
  instance.names = NULL,
  question = "Why?",
  negative.color = "firebrick",
  positive.color = "steelblue"
)
}
\arguments{
\item{ciu.meta.result}{\code{ciu.meta.result} object for the instance to be explained,
i.e. the first instance parameter of \link{ciu.contrastive}.}

\item{contrastive.influences}{Contrastive influence values, as normally returned
by \link{ciu.contrastive}.}

\item{instance.names}{Vector with the labels to be used for the compared
classes/instances. If NULL, then we use \code{c("instance One", "instance Two")}.}

\item{question}{What kind of explanation do we answer. Can be "Why?" and
"Why not?". Default is "Why?".}

\item{negative.color}{Color to use for negative influence. Default is firebrick.}

\item{positive.color}{Color to use for positive influence. Default is steelblue.}
}
\value{
\code{ggplot} object.
}
\description{
Create contrastive ggplot
}
\examples{
library(ciu)
library(MASS)
test.ind <- 100
iris_test <- iris[test.ind, 1:4]
iris_train <- iris[-test.ind, 1:4]
iris_lab <- iris[[5]][-test.ind]
model <- lda(iris_train, iris_lab)
# Create CIU object
ciu <- ciu.new(model, Species~., iris)
# First case: why is this a versicolor and not a virginica?
meta <- ciu$meta.explain(iris_test)
ciuvals.versicolor <- ciu.list.to.frame(meta$ciuvals, out.ind = 2)
ciuvals.virginica <- ciu.list.to.frame(meta$ciuvals, out.ind = 3)
# Now the contrastive part:
contrastive <- ciu.contrastive(ciuvals.versicolor, ciuvals.virginica)
print(ciu.ggplot.contrastive(meta, contrastive, c("Versicolor", "Virginica")))
# Then a "Why not?" explanation
contrastive.neg <- ciu.contrastive(ciuvals.virginica, ciuvals.versicolor)
print(ciu.ggplot.contrastive(meta, contrastive.neg,
  question = "Why not?", c("Virginica", "Versicolor")))
}
\author{
Kary Främling
}
