% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{reports_get_sql}
\alias{reports_get_sql}
\title{Get a single SQL report}
\usage{
reports_get_sql(id)
}
\arguments{
\item{id}{integer required. The ID of this report.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of this report.}
\item{name}{string, The name of the report.}
\item{user}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{createdAt}{string, The creation time for this report.}
\item{updatedAt}{string, The last updated at time for this report.}
\item{type}{string, The type of the report. One of: ReportTypes::HTML, ReportTypes::Tableau, ReportTypes::ShinyApp, ReportTypes::SQL}
\item{description}{string, The user-defined description of the report.}
\item{myPermissionLevel}{string, Your permission level on the object. One of "read", "write", or "manage".}
\item{archived}{string, The archival status of the requested item(s).}
\item{config}{string, The configuration of the report visualization.}
\item{query}{list, A list containing the following elements: 
\itemize{
\item id integer, The query ID.
\item database integer, The database ID.
\item sql string, The SQL to execute.
\item credential integer, The credential ID.
\item resultRows array, A preview of rows returned by the query.
\item resultColumns array, A preview of columns returned by the query.
\item error string, The error message for this run, if present.
\item startedAt string, The start time of the last run.
\item finishedAt string, The end time of the last run.
\item state string, The state of the last run. One of queued, running, succeeded, failed, and cancelled.
\item runningAs list . A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}
}}
}
\description{
Get a single SQL report
}
