% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{scripts_list_r_runs}
\alias{scripts_list_r_runs}
\title{List runs for the given R job}
\usage{
scripts_list_r_runs(
  id,
  limit = NULL,
  page_num = NULL,
  order = NULL,
  order_dir = NULL
)
}
\arguments{
\item{id}{integer required. The ID of the R job.}

\item{limit}{integer optional. Number of results to return. Defaults to 20. Maximum allowed is 100.}

\item{page_num}{integer optional. Page number of the results to return. Defaults to the first page, 1.}

\item{order}{string optional. The field on which to order the result set. Defaults to id. Must be one of: id.}

\item{order_dir}{string optional. Direction in which to sort, either asc (ascending) or desc (descending) defaulting to desc.}
}
\value{
An array containing the following fields:
\item{id}{integer, The ID of the run.}
\item{rId}{integer, The ID of the R job.}
\item{state}{string, The state of the run, one of 'queued' 'running' 'succeeded' 'failed' or 'cancelled'.}
\item{isCancelRequested}{boolean, True if run cancel requested, else false.}
\item{createdAt}{string, The time the run was created.}
\item{startedAt}{string, The time the run started at.}
\item{finishedAt}{string, The time the run completed.}
\item{error}{string, The error, if any, returned by the run.}
\item{maxMemoryUsage}{number, If the run has finished, the maximum amount of memory used during the run, in MB.}
\item{maxCpuUsage}{number, If the run has finished, the maximum amount of cpu used during the run, in millicores.}
}
\description{
List runs for the given R job
}
