% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{users_list_me_activity}
\alias{users_list_me_activity}
\title{Get recent activity for logged-in user}
\usage{
users_list_me_activity(status = NULL, author = NULL, order = NULL)
}
\arguments{
\item{status}{string optional. The status to filter objects by. One of "all", "succeeded", "failed", or "running".}

\item{author}{string optional. A comma separated list of author IDs to filter objects by.}

\item{order}{string optional. The order of the jobs. If set to "name", the order is DESC alphabetically. If set to "newest", the order is DESC by most recently updated.}
}
\value{
An array containing the following fields:
\item{id}{string, The ID of the object.}
\item{name}{string, The name of the object.}
\item{type}{string, The type of the object.}
\item{user}{string, The user associated with the object.}
\item{category}{string, The job category, if the object is a job.}
\item{state}{string, The state of the object. One of "succeeded", "failed", or "running".}
\item{updatedAt}{string, When the object was last updated.}
\item{nextRunAt}{string, When the job is next scheduled to run, if the object is a job.}
\item{lastRunId}{string, The ID of the last run, if the object is a job.}
\item{lastRunState}{string, The state of the last run, if the object is a job. One of "succeeded", "failed", or "running".}
}
\description{
Get recent activity for logged-in user
}
