% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clc.R
\name{clc}
\alias{clc}
\title{`clc` S3 Class}
\usage{
clc(source, layer_name, field = NULL)
}
\arguments{
\item{source}{The source of the vector layer. This can be:
- A string representing the path to a GeoPackage file.
- A `DBI` database connection object to a PostGIS database, created using [RPostgres::dbConnect()].}

\item{layer_name}{The name of the layer in the source to be used.}

\item{field}{(Optional) A string, the layer field that contains CLC codes. If NULL,
the function will attempt to locate the column containing the CLC codes.}
}
\value{
An object of class `clc`.
}
\description{
Create an object of class `clc`.
}
\details{
This function creates an object of class `clc` from a vector layer in either
a GeoPackage or a PostGIS database.

The layer must have a style defined in the source.
}
\examples{
# ex1
source_gpkg <- system.file("extdata", "clc.gpkg", package = "clc")
clo <- clc(source = source_gpkg, layer_name = "clc")

\dontrun{
# ex2
conn <- RPostgres::dbConnect(
  RPostgres::Postgres(),
  dbname = 'exampledb',
  host = 'localhost',
  port = '5432',
  user = 'user',
  password = 'password'
)
clo <- clc(source = conn, layer_name = "clc")
}
}
\seealso{
Other CLC class functions: 
\code{\link{as_raster}()},
\code{\link{copy_to}()},
\code{\link{cut_to_extent}()},
\code{\link{get_colors.clc}()},
\code{\link{get_levels.clc}()},
\code{\link{get_raster}()},
\code{\link{plot_clc}()},
\code{\link{prepare_plot}()},
\code{\link{save_to}()}
}
\concept{CLC class functions}
