% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clc.R, R/clc_raster.R
\name{plot_clc}
\alias{plot_clc}
\alias{plot_clc.clc}
\alias{plot_clc.clc_raster}
\title{Plot CLC Layer}
\usage{
plot_clc(clo, ...)

\method{plot_clc}{clc}(clo, ...)

\method{plot_clc}{clc_raster}(clo, ...)
}
\arguments{
\item{clo}{An object containing CLC data. This must be an instance of a supported class, such as:
- A vectorial CLC data object (e.g., `clc` object).
- A raster CLC data object (e.g., `clc_raster`).}

\item{...}{Additional arguments passed to the `terra::plot` function.}
}
\value{
A `ggplot2` object or a `terra` plot.
}
\description{
Plot CLC data stored in objects of supported classes. The function adapts the plot
based on the class of the input data (vectorial or raster format).
}
\details{
For the raster version, the `terra::plot` function is used with the `col` parameter
configured, while all other parameters supported by the function can also be defined (using `...`).

For the vector version, `ggplot2::ggplot` is used, and by using the `prepare_plot` function
instead of this one (`plot_clc`), further customization can be applied as needed.
}
\examples{
source_gpkg <- system.file("extdata", "clc.gpkg", package = "clc")
clo <- clc(source = source_gpkg, layer_name = "clc")

temp_file <- tempfile(fileext = ".png")
png(filename = temp_file, width = 800, height = 600)

clo |>
  plot_clc()

dev.off()

}
\seealso{
\code{\link{prepare_plot}}

Other CLC class functions: 
\code{\link{as_raster}()},
\code{\link{clc}()},
\code{\link{copy_to}()},
\code{\link{cut_to_extent}()},
\code{\link{get_colors.clc}()},
\code{\link{get_levels.clc}()},
\code{\link{get_raster}()},
\code{\link{prepare_plot}()},
\code{\link{save_to}()}
}
\concept{CLC class functions}
