% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigugr_clip.R
\name{safe_clip_multipoligon}
\alias{safe_clip_multipoligon}
\title{Safely Clip a Multipolygon Vector Layer}
\usage{
safe_clip_multipoligon(vector, polygon)
}
\arguments{
\item{vector}{A `sf` multipolygon vector layer to be clipped.}

\item{polygon}{A `sf` polygon layer used as the clipping geometry.}
}
\value{
A `sf` vector layer with the clipped geometries.
}
\description{
This function clips a `MULTIPOLYGON` vector layer using a polygon layer, handling specific
issues that might arise with geometries encoded incorrectly or containing unknown WKB types.
It serves as a fallback when the `clip_vector()` function fails due to errors like
`ParseException: Unknown WKB type 12`, which is associated with *MULTIPOLYGON* types.
}
\details{
The function ensures that the input layer is correctly encoded as `MULTIPOLYGON` and
uses GDAL utilities for re-encoding if necessary. The output is projected to the CRS
of the clipping polygon.

This solution is inspired by a discussion on handling WKB type errors in R:
<https://gis.stackexchange.com/questions/389814/r-st-centroid-geos-error-unknown-wkb-type-12>.
}
\examples{
gpkg_path <- system.file("extdata", "clc.gpkg", package = "clc")

clc <- sf::st_read(gpkg_path, layer = "clc")
lanjaron <- sf::st_read(gpkg_path, layer = "lanjaron")

clc_clipped <- safe_clip_multipoligon(clc, lanjaron)

}
\concept{independent functions}
